#include <unistd.h>
#include <stdio.h>
int main(void) {
int num, dbl, nbytes, pipe2child[2], pipe2parent[2];
pid_t pid; FILE *infp, *outfp;
if (pipe(pipe2child) == -1) {perror("creating pipe2child"); exit(1);}
if (pipe(pipe2parent) == -1) {perror("creating pipe2parent"); exit(1);}
if ((pid = fork()) == -1) {perror("cannot fork"); exit(1);}
else if (pid > 0) { /* parent */
	close(pipe2child[0]); close(pipe2parent[1]);
	infp = fdopen(pipe2parent[0], "r"); outfp = fdopen(pipe2child[1] , "w");
	for (num = 0; num < 20; num++) {
		if (fprintf(outfp, "%d\n", num ) < 0) {
			perror("sending data to child"); break;}
		if (fscanf(infp, "%d", &dbl) != 1) {
			perror("getting data from child"); break; }
		printf("2 * %d = %d\n", num, dbl); }
	fclose(infp); fclose(outfp);
}
else { /* child */
	close(pipe2child[1]); close(pipe2parent[0]);
	infp = fdopen(pipe2child[0] , "r"); outfp = fdopen(pipe2parent[1] , "w");
	while ((num = fscanf(infp, "%d", &dbl)) 	 == 1) {
		dbl = 2 * num;
		if (fprintf(outfp, "%d\n", dbl) < 0) {
			perror("sending data to parent"); break; }
  }
	fclose(infp); fclose(outfp);
}
return 0;}


