#include <unistd.h>
#include <stdio.h>

int main(void) {
int num, dbl, nbytes, pipe2child[2], pipe2parent[2];
pid_t pid;
if (pipe(pipe2child) == -1) {perror("creating pipe2child"); exit(1);}
if (pipe(pipe2parent) == -1) {perror("creating pipe2parent"); exit(1);}
if ((pid = fork()) == -1) {perror("cannot fork"); exit(1);}
else if (pid > 0) { /* parent */
	close(pipe2child[0]); close(pipe2parent[1]);
	for (num = 0; num < 20; num++) {
		if (write(pipe2child[1], &num, sizeof(int)) != sizeof(int)) {
			perror("sending data to child"); break;}
		if (read(pipe2parent[0], &dbl, sizeof(int)) != sizeof(int)) {
			perror("getting data from child"); break; }
		printf("2 * %d = %d\n", num, dbl);
	}
	close(pipe2child[1]); close(pipe2parent[0]);
}
else { /* child */
	close(pipe2child[1]); close(pipe2parent[0]);
	while ((nbytes = read(pipe2child[0], &num, sizeof(int))) == sizeof(int)) {
		dbl = 2 * num;
		if (write(pipe2parent[1], &dbl, sizeof(int)) != sizeof(int)) {
			perror("sending data to parent"); break; }
  }
	close(pipe2child[0]); close(pipe2parent[1]);
}
return 0;}


