#include <signal.h>
#include <stdio.h>
void sighdl(int signo) {
        printf("pid %d: Signal %d received\n", getpid(), signo);
        signal(signo, sighdl);
}

int main(void) {

pid_t childpid;

signal(SIGINT, sighdl);
signal(SIGSEGV, sighdl);
signal(SIGUSR1, sighdl);
if ((childpid = fork()) == -1) {perror("Cannot fork"); exit(1);}
else if (childpid == 0) { /* child */
        kill(getppid(), SIGINT); 
        kill(getppid(), SIGSEGV);
        kill(getppid(), SIGUSR1);
        return 0;
}
waitpid(childpid, NULL);
return 0;
}



