#include <stdio.h>


int main(int argc, char *argv[]) {
	FILE *infp, *outfp;
	int c;

	if ((infp = fopen(argv[1], "rb")) == NULL) {
		fprintf(stderr, "Cannot open input file\n");
		exit(1);
	}
	if ((outfp = fopen(argv[2], "wb")) == NULL) {
		fprintf(stderr, "Cannot open output file\n");
		exit(1);
	}

	while ((c = fgetc(infp)) != EOF)
		if (fputc(c, outfp) == EOF) {
			fprintf(stderr, "Cannot write bytes\n");
			break;
		}
	if (!feof(infp))
		fprintf(stderr, "Input error\n");
	fclose(infp);
	fclose(outfp);
	return 0;
}
