#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
int accmode, val;

if (argc != 2) return 2;

if ((val = fcntl(atoi(argv[1]), F_GETFL, 0)) == -1) {
	perror(argv[1]);
	exit(1);
}
accmode = val & O_ACCMODE;
if (accmode == O_RDONLY) puts("Read only");
else if (accmode == O_WRONLY) puts("Write only");
else if (accmode == O_RDWR) puts("Read/Write");
else puts("*** Unknown access mode ***");

if (val & O_APPEND) printf("Append");
if (val & O_NONBLOCK) printf(", non-blocking");
#if defined(O_SYNC)
if (val & O_SYNC) printf(", synchronous writes");
#endif
#if defined(O_ASYNC)
if (val & O_SYNC) printf(", asynchronous I/O");
#endif
putchar('\n');
return 0;
}
