#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>

int main(int argc, char *argv[]) {
int fd, nbytes, cnt;
char buf[3];

if (argc == 1) return;
if ((fd = open(argv[1], O_RDONLY)) == -1) {
	perror(argv[1]);
	exit(1);
}
if (lseek(fd, (off_t)5, SEEK_SET) == -1) {
	perror("cannot seek");
	close(fd);
	exit(1);
}
if ((nbytes = read(fd, buf, 3)) == -1) {
	perror("Cannot read");
	close(fd);
	exit(1);
}
printf("read %d bytes\n", nbytes);
for (cnt = 0; cnt < nbytes; cnt++) putchar(buf[cnt]);
putchar('\n');
close(fd);
return 0;
}
