#include <pthread.h>
#include <stdio.h>
#include <errno.h>

pthread_mutex_t mutex;

int main(int argc, char **argv)
{
  pthread_mutexattr_t mta;
  int type = PTHREAD_MUTEX_DEFAULT, rc, i;

  if (argc > 1 && argv[1][0] == 'r') type = PTHREAD_MUTEX_RECURSIVE;
  else if (argc > 1 && argv[1][0] == 'e') type = PTHREAD_MUTEX_ERRORCHECK;
  printf("Mutex type is %d\n", type);
  rc = pthread_mutexattr_init(&mta);

  printf("Setting mutex type...\n");
  rc = pthread_mutexattr_settype(&mta, type);

  printf("Initialising mutex...\n");
  rc = pthread_mutex_init(&mutex, &mta);
  printf("Lock the mutex\n");
  rc = pthread_mutex_lock(&mutex);

  printf("Re-Lock the mutex\n");
  rc = pthread_mutex_lock(&mutex);
  if (rc != 0) printf("re-lock: %s\n", strerror(rc));

  printf("Unlock the mutex 3 times\n");
  for (i = 0; i < 3; i++)
  	if ((rc = pthread_mutex_unlock(&mutex)) != 0)
		printf("Unlock: %s\n", strerror(rc));

  printf("Cleanup\n");
  rc = pthread_mutex_destroy(&mutex);
  return 0;
}

