#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>

#define FIFO_NAME "/tmp/mylog"

int main(void) {
int fd, nbytes, replyFd, ctr, strStart;
char buff[512];
char str[512];
char myPipeName[L_tmpnam + 1];

if (tmpnam(myPipeName) == NULL) {perror("generating pipe name"); exit(1);}
printf("input pipe is %s\n", myPipeName);
if (mkfifo(myPipeName, 0622) == -1) {
        perror("cannot mkfifo"); exit(1); }
if ((replyFd = open(myPipeName, O_RDONLY | O_NONBLOCK)) == -1) {
        perror("opening reply FIFO"); unlink(myPipeName); exit(1); }
if ((fd = open(FIFO_NAME, O_WRONLY | O_NONBLOCK)) == -1) {
        perror("opening request FIFO"); unlink(myPipeName); exit(1); }
while (1) {
        printf("Enter input: ");
        gets(str);
        nbytes = sprintf(buff, "%s%c%s", myPipeName, '\0', str);
        nbytes = write(fd, buff, nbytes + 1);
        errno = 0;
        while ((nbytes = read(replyFd, buff, 512)) == 0) {
		printf("0 bytes read\n");
                if (errno != 0)
                        break;
	}
        if (nbytes > 0)
                printf("reply = %s\n", buff);
        else
                perror("reading");
}
close(fd);
close(replyFd);
if (unlink(myPipeName) == -1) {perror("cannot unlink");}
return 0;
}

