#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>

#define FIFO_NAME "/tmp/mylog"

int main(void) {
int fd, nbytes, replyFd, ctr, strStart;
char buff[512];

if (mkfifo(FIFO_NAME, 0622) == -1) {
        perror("cannot mkfifo"); exit(1); }
if ((fd = open(FIFO_NAME, O_RDONLY)) == -1) {
        perror("opening FIFO"); unlink(FIFO_NAME); exit(1); }
while (1) {
        nbytes = read(fd, buff, 512);
        if (nbytes > 0) {
                /* skip name of return pipe to locate string */
                for (ctr = 0; buff[ctr] != '\0'; ctr++)
                        ;
                strStart = ctr + 1;
                for (ctr = strStart; buff[ctr] != '\0'; ctr++)
                        buff[ctr] = toupper(buff[ctr]);
                printf("reply is %s; posted to %s\n", buff + strStart, buff);
                if ((replyFd = open(buff, O_WRONLY | O_NONBLOCK)) != -1) {
                        write(replyFd, buff + strStart, ctr - strStart + 1);
                        close(replyFd);
                }
                else perror("cannot open reply channel");
        }
}
close(fd);
if (unlink(FIFO_NAME) == -1) {perror("cannot unlink");}
return 0;
}


