#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
int main(void) {
	int n, fd[2];
	pid_t pid;
	char buff[512];
	
	if (pipe(fd) < 0) {perror("creating pipe"); exit(1); }
	if ((pid = fork()) < 0) {perror("cannot fork"); exit(1); }
	else if (pid > 0) { /*   */
		close(fd[0]); /*     */
		for (n = 0; n < 100; n++) {
			sprintf(buff, "Message %d through pipe\n", n);
			if (write(fd[1], buff, strlen(buff)) != strlen(buff)) perror("writing message");
		}
		close(fd[1]);
		waitpid(pid, NULL, 0);
	} else { /*   */
		close(fd[1]); /*     */
		if (dup2(fd[0], STDIN_FILENO) == -1) {perror("cannot dup2"); exit(1);}
		close(fd[0]);
		execlp("more", "more", NULL);
		perror("execlp returned!");
	}
	exit(0);
}
