#include <pthread.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>

typedef struct job {
	int weight;
	struct job *next;
} job;

#define WEIGHT_MAX 5
#define BUFFER_MAX 5
struct job *jobQueue = NULL;
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t readerCond = PTHREAD_COND_INITIALIZER,
	writerCond = PTHREAD_COND_INITIALIZER;
int nreaders = 0, nwriters = 0, pendingWriters = 0;

void *reader(void *param) {
long myId = (long)(pthread_self());

while (1) {
	sleep(1 + rand() % 4);
	printf("Thread %ld (reader): wanna read...\n", myId);
	pthread_mutex_lock(&mutex);
	if (nwriters != 0) pthread_cond_wait(&readerCond, &mutex);
	nreaders++;
	pthread_mutex_unlock(&mutex);
	printf("Thread %ld (reader): starting read\n", myId);
	sleep(1 + rand() % 4);
	printf("Thread %ld (reader): done reading\n", myId);
	pthread_mutex_lock(&mutex);
	nreaders--;
	if (nreaders == 0) pthread_cond_signal(&writerCond);
	pthread_mutex_unlock(&mutex);
}
return NULL;
}

void *writer(void *param) {
long myId = (long)(pthread_self());

while (1) {
	sleep(1 + rand() % 6);
	printf("Thread %ld (writer): wanna write...\n", myId);
	pthread_mutex_lock(&mutex);
	pendingWriters++;
	if (nreaders != 0 || nwriters != 0) pthread_cond_wait(&writerCond, &mutex);
	nwriters++;
	pendingWriters--;
	pthread_mutex_unlock(&mutex);
	printf("Thread %ld (writer): starting write\n", myId);
	sleep(1 + rand() % 4);
	printf("Thread %ld (writer): done writing\n", myId);
	pthread_mutex_lock(&mutex);
	nwriters--;
	if (pendingWriters != 0) pthread_cond_signal(&writerCond);
	else pthread_cond_broadcast(&readerCond);
	pthread_mutex_unlock(&mutex);
}
return NULL;
}

int main(void) {
int nread, nwrite, i;
pthread_t tid;

printf("Enter number of readers: ");
scanf("%d", &nread);
printf("Enter number of writers: ");
scanf("%d", &nwrite);

for (i = 0; i < nwrite; i++)
	pthread_create(&tid, NULL, writer, NULL);
for (i = 0; i < nread; i++)
	pthread_create(&tid, NULL, reader, NULL);

pthread_join(tid, NULL);
return 0;
}
