#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>

void err_die(char *err) {
	perror(err);
	exit(1);
}
int main(int argc, char *argv[]) {
	DIR *dp;
	struct dirent *dirp;
	char thePath[PATH_MAX];
	if (argc != 2) err_die("provide the directory name");
	if ((dp = opendir(argv[1])) == NULL)
		err_die("Directory open error");
	while ((dirp = readdir(dp)) != NULL) {
		printf("%lu\t%-30s\t", (unsigned long)(dirp->d_ino), dirp->d_name);
		sprintf(thePath, "%s/%s", argv[1], dirp->d_name);
		putchar(access(thePath, R_OK) == 0 ? 'r' : '-');
		putchar(access(thePath, W_OK) == 0 ? 'w' : '-');
		putchar(access(thePath, X_OK) == 0 ? 'x' : '-');
		putchar('\n');
	}
	closedir(dp);
	return 0;
}


