#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

void printLimit(const char *limitName, int theLimit) {
struct rlimit lim;

if (getrlimit(theLimit, &lim) == -1)
        printf("%s: cannot get limit");
else {
        printf("%s: ", limitName);
        if (lim.rlim_cur == RLIM_INFINITY)
                printf("\tUnlimited \t");
        else
                printf("\t%10ld\t", (long)(lim.rlim_cur));
        if (lim.rlim_max == RLIM_INFINITY)
                printf("\tUnlimited\n");
        else
                printf("\t%10ld\t", (long)(lim.rlim_max));
        lim.rlim_cur = (lim.rlim_cur == RLIM_INFINITY) ? 500000L : lim.rlim_cur / 2;
        setrlimit(theLimit, &lim);
}
}

int main(void) {
        printLimit("RLIMIT_CORE", RLIMIT_CORE);
        printLimit("RLIMIT_CPU", RLIMIT_CPU);
#define doLimit(x) printLimit(#x, x)
        doLimit(RLIMIT_CPU);
        doLimit(RLIMIT_FSIZE);
        return 0;
}

