#include <signal.h>
#include <stdio.h>

int fpe_occured = 0;

void sig_fpe(int siginfo) {
	signal(SIGFPE, SIG_IGN);
	fprintf(stderr, "Floating point error!");
	fpe_occured = 1;
	signal(SIGFPE, sig_fpe);
	return;
}

void sig_int(int siginfo) {
	printf("Ctrl-C pressed. Bye-Bye!\n");
	exit(0);
}

int main(void) {
	int a, b, c;
	
	signal(SIGFPE, sig_fpe);
	signal(SIGINT, sig_int);
	for ( ; ; ) {
		printf("Enter a: ");
		scanf("%d", &a);
		printf("Enter b: ");
		scanf("%d", &b);
		c = a / b;
		if (fpe_occured) {
			fpe_occured = 0;
			fprintf(stderr, "Cannot perform division\n");
		}
		else
			printf("Result = %d\n", c);
	}
}
		
