#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

int main(void) {

struct stat link_stat, file_stat;
char buf[512];
int result;

if (symlink("/etc/passwd", "mylink") == -1) {
	perror("symlink mylink to /etc/passwd");
	exit(1);
}

if (stat("mylink", &file_stat) == -1) {
	perror("cannot stat mylink");
	exit(1);
}

if (lstat("mylink", &link_stat) == -1) {
	perror("cannot stat mylink");
	exit(1);
}

printf("stat size: %ld, lstat size: %ld\n",
	(long)(file_stat.st_size), (long)(link_stat.st_size));

if ((result = readlink("mylink", buf, 511)) == -1) {
	perror("reading mylink link contents");
	exit(1);
}
buf[result] = '\0';
printf("mylink contents: %s\n", buf);

if (unlink("mylink") == -1) {
	perror("unlinking mylink");
	exit(1);
}
return 0;
}
