#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

typedef struct {
        char isbn[20]; int yearPub;
        char title[32]; float price;
} book;

int main(void) {
int fd;
ssize_t nbytes;
off_t new_len;
book theBook;

if ((fd = open("books.dat", O_RDWR)) == -1) {
	perror("Cannot open books.dat");
	exit(1);
}
new_len = lseek(fd, 0, SEEK_END);
if ((new_len = lseek(fd, -(off_t)sizeof(book), SEEK_END)) == -1) {
	perror("cannot seek");
	close(fd);
	exit(1);
}
if ((nbytes = read(fd, &theBook, sizeof(book))) != sizeof(book)) {
	perror("cannot read");
	close(fd);
	exit(1);
}
if (lseek(fd, sizeof(book), SEEK_SET) == -1) {
	perror("cannot seek");
	close(fd);
	exit(1);
}
if ((nbytes = write(fd, &theBook, sizeof(book))) != sizeof(book)) {
	perror("cannot write");
	close(fd);
	exit(1);
}
if (ftruncate(fd, new_len) == -1) {
	perror("error in truncation");
	close(fd);
	exit(1);
}
close(fd);
return 0;
}
