#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>

#define BUFFERSIZE 4096

int main(void) {
int fd;
ssize_t num_bytes;
long loop_counter = 0;
char buff[BUFFERSIZE];

fprintf(stderr, "%d\n", fcntl(STDOUT_FILENO, F_SETFL, fcntl(STDOUT_FILENO, F_GETFL, 0) | O_SYNC));
while ((num_bytes = read(STDIN_FILENO, buff, BUFFERSIZE)) > 0) {
	if (write(STDOUT_FILENO, buff, num_bytes) < num_bytes) {
		perror("writing file");
		break;
	}
	loop_counter++;
}
if (num_bytes < 0)
	perror("reading file");
fprintf(stderr, "%ld loops done\n", loop_counter);
return 0;
}

