#include <fcntl.h>
#include <stdio.h>

#define BUFSIZE 8192

int main(int argc, char *argv[]) {
	int infd, outfd, nbytes;
	char buf[BUFSIZE];

	if ((infd = open(argv[1], O_RDONLY)) == -1) {
		fprintf(stderr, "Cannot open input file\n");
		exit(1);
	}
	if ((outfd = open(argv[2], O_WRONLY | O_CREAT, 0644)) == -1) {
		fprintf(stderr, "Cannot open output file\n");
		exit(1);
	}

	while ((nbytes = read(infd, buf, BUFSIZE)) > 0)
		if (write(outfd, buf, nbytes) != nbytes) {
			fprintf(stderr, "Cannot write bytes\n");
			break;
		}
	if (nbytes < 0)
		fprintf(stderr, "Input error\n");
	close(infd);
	close(outfd);
	return 0;
}
