#include	<sys/types.h>
#include	<sys/wait.h>

char	*env_init[] = {"USER=unknown", "PATH=/tmp", NULL};
char *args[] = {"arg1", "second argument", "3rd arg", NULL};

int main(int argc, char *argv)
{
	pid_t	pid;

	if ( (pid = fork()) < 0)
		perror("fork error");
	else if (pid == 0) {	/* specify pathname, specify environment */
		if (execle("echoall", "echoall-program", "myarg1", "MY ARG2", (char *) 0,
				   env_init) < 0)
		perror("execle error");
	}
	if (waitpid(pid, NULL, 0) < 0)
		perror("wait error");

	if ( (pid = fork()) < 0)
		perror("fork error");
	else if (pid == 0) {	/* specify filename, inherit environment */
		if (execvp("echoall", args) < 0)
			perror("execvp error");
	}
	exit(0);
}
