#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#define BYTES_TO_READ 1000

size_t fileSize(char *path) {
int fd;
size_t result = 0, nbytes;
char buff[BYTES_TO_READ];

if ((fd = open(path, O_RDONLY)) == -1) {
	perror(path);
	return -1;
}
while ((nbytes = read(fd, buff, BYTES_TO_READ)) > 0)
	result += nbytes;
if (nbytes == -1)
	perror(path);
close(fd);
return result;
}

int main(int argc, char *argv[]) {
	if (argc > 1)
		printf("Filesize of %s is: %d\n", argv[1], fileSize(argv[1]));
	return 0;
}
