#include <unistd.h>
#include <errno.h>
#include <limits.h>

#ifdef PATH_MAX
size_t max_path_len = PATH_MAX;
#else
size_t max_path_len = 0;
#endif

#define MAX_PATH_GUESS 8192

size_t get_maxpath(void) {
	if (max_path_len == 0) {
		errno = 0;
		if ((max_path_len = pathconf("/", _PC_PATH_MAX)) == -1) {
			if (errno == 0)
				max_path_len = MAX_PATH_GUESS;
			else {
				perror("_PC_PATH_MAX: ");
				exit(1);
			}
		}
	}
	return max_path_len;
}

int main(void) {
	printf("%ld\n", (long)get_maxpath());
	return 0;
}
			
