#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <termios.h>
#include <termio.h>
#include <stdio.h>

#ifndef SYSV
struct sgttyb savetty, settty;

int set_term()
{
  struct sgttyb savetty, settty;
  ioctl(0, TIOCGETP, &savetty);
  /* saves original */
  ioctl(0, TIOCGETP, &settty); /* get orig to modify */
  settty.sg_flags |= CBREAK; 
  settty.sg_flags &= ~ECHO;
  ioctl(0, TIOCSETP, &settty);
}

int reset_term()
{
  ioctl(0, TIOCSETP, &savetty);
}
#else
struct termio savetty, settty;
int set_term()
{
  ioctl(0, TCGETA, &savetty);
  ioctl(0, TCGETA, &settty);
  settty.c_lflag &= ~ICANON;
  settty.c_lflag &= ~ECHO;
  ioctl(0, TCSETAF, &settty);
}

int reset_term()
{
  ioctl(0, TCSETAF, &savetty);
}
#endif


main()
{
  /*make the terminal unbuffered*/
  set_term();
  while (1) {
  char a;

  if ((a=getchar())!=EOF) {
     /*we are going to get a char, print it out, followed by 2 dots*/
     putchar(a);
     fflush(stdout);
     printf("..");
   } else {
     /*set the terminal like we got it*/
     reset_term();
     exit(1);
   }
 }
}



