#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>

#define MAX_NAME_GUESS 256

int make_long_filename(char *path) {
char *theFileName;
int fd, theSize, ctr, pathLen = strlen(path);

if ((theSize = pathconf(path, _PC_NAME_MAX)) == -1) {
	if (errno == 0)
		theSize = MAX_NAME_GUESS;
	else {
		perror("_PC_NAME_MAX: ");
		exit(1);
	}
}
if ((theFileName = malloc(theSize + pathLen + 4)) == NULL) {
	perror("malloc");
	exit(1);
}
strcpy(theFileName, path);
theFileName[pathLen] = '/';
for (ctr = 1; ctr <= theSize + 1; ctr++) theFileName[pathLen + ctr] = 'a';
theFileName[pathLen + ctr] = '\0';
if ((fd = open(theFileName, O_WRONLY | O_CREAT, S_IRWXU)) == -1) {
	perror(theFileName);
	return -1;
}
printf("Created %s\n", theFileName);
close(fd);
return 0;
}

int main(void) {
	make_long_filename("/tmp");
	make_long_filename(".");
	return 0;
}
