#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>

int main(void) {
	char buf[1024], *rd_status;
	pid_t pid;
	int status;

	for ( ; ; ) {
		printf("Enter command (no params): ");
		rd_status = gets(buf);
		if ((rd_status == NULL) || (buf[0] == 0)) break;
		if ((pid = fork()) < 0) {
			fprintf(stderr, "fork error");
			exit(1);
		}
		else if (pid == 0) { /* child here */
			execlp(buf, buf, NULL);
			fprintf(stderr, "Cannot execute %s\n", buf);
			exit(2);
		}
		/* parent here */
		if ((pid = waitpid(pid, &status, 0)) < 0) {
			fprintf(stderr, "waitpid error\n");
			exit(1);
		}
	} 
	return 0;
}
