#include <pthread.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>

typedef struct job {
	int weight;
	struct job *next;
} job;

#define WEIGHT_MAX 5
#define BUFFER_MAX 5
sem_t empty, full;
struct job *jobQueue = NULL;
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

struct job *enqueue(job **theQueue, job *theJob) {
struct job **retval = theQueue;

while (*theQueue != NULL)
	theQueue = &((*theQueue)->next);
theJob->next = NULL;
*theQueue = theJob;
return *retval;
}

struct job *dequeue(job **theQueue) {
struct job *retval = *theQueue;

if (retval == NULL) return NULL;
*theQueue = retval->next;
retval->next = NULL;
return retval;
}


void *producer(void *param) {
struct job *newJob;
long myId = (long)(pthread_self());

while (1) {
	if ((newJob = malloc(sizeof(job))) == NULL) {
		fprintf(stderr, "Thread %ld: cannot allocate mem\n", myId);
		return NULL;
	}
	newJob->weight = rand() % WEIGHT_MAX;
	sleep(1 + newJob->weight + rand() % 2);
	printf("Thread %ld: created job, W = %d\n", myId, newJob->weight);
	sem_wait(&empty);
	pthread_mutex_lock(&mutex);
	enqueue(&jobQueue, newJob);
	pthread_mutex_unlock(&mutex);
	printf("Thread %ld: deposited job, W = %d\n", myId, newJob->weight);
	sem_post(&full);
}
return NULL;
}

void *consumer(void *param) {
struct job *nextJob;
long myId = (long)(pthread_self());

while (1) {
	sem_wait(&full);
	pthread_mutex_lock(&mutex);
	nextJob = dequeue(&jobQueue);
	pthread_mutex_unlock(&mutex);
	sem_post(&empty);
	if (nextJob == NULL) {
		fprintf(stderr, "Thread %ld: got NULL job!\n", myId);
		continue;
	}
	printf("Thread %ld: got job, W = %d\n", myId, nextJob->weight);
	sleep(1 + nextJob->weight + rand() % 2);
	printf("Thread %ld: consumed job, W = %d (yummy!)\n", myId, nextJob->weight);
}
return NULL;
}

int main(void) {
int nprod, ncons, i;
pthread_t tid;

sem_init(&empty, 0, BUFFER_MAX);
sem_init(&full, 0, 0);
printf("Enter number of producers: ");
scanf("%d", &nprod);
printf("Enter number of consumers: ");
scanf("%d", &ncons);

for (i = 0; i < ncons; i++)
	pthread_create(&tid, NULL, consumer, NULL);
for (i = 0; i < nprod; i++)
	pthread_create(&tid, NULL, producer, NULL);

pthread_join(tid, NULL);
return 0;
}
