#include <pthread.h>
#include <stdio.h>

pthread_key_t thread_result_file;
pthread_key_t thread_ordinal;

void worker() {
FILE *theFile;
int theId;

theId = *(int *)(pthread_getspecific(thread_ordinal));
theFile = (FILE *)(pthread_getspecific(thread_result_file));
fprintf(theFile, "thread %d: bored to do any work\n", theId);
}

void *worker_init(void* parameters) {
FILE *myOutput;
char myFileName[128];
int myId;
myId = (int)(parameters);
pthread_setspecific(thread_ordinal, &myId);
sprintf(myFileName, "%s%d", "result", myId);
myOutput = fopen(myFileName, "w");
pthread_setspecific(thread_result_file, myOutput);
worker();
return NULL;
}

void close_result_file(void *theFile) {
fclose((FILE *)theFile);
}


/* Main program. */
int main () {
pthread_t thread1_id, thread2_id;

pthread_key_create(&thread_result_file, close_result_file);
pthread_key_create(&thread_ordinal, NULL);

pthread_create(&thread1_id, NULL, worker_init, (void *)1);
pthread_create(&thread2_id, NULL, worker_init, (void *)2);

pthread_join(thread1_id, NULL);
pthread_join(thread2_id, NULL);
return 0;
}

