#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#define SEM_KEY ((key_t)2789)
#define NUM_SEMS 2

int main(void) {
int semid;
ushort_t semValues[2], count;
int res;
union semun {
	int val;
	struct semid_ds *buf;
	ushort_t *array;
} arg ;
struct sembuf theSemOp;


if ((semid = semget(SEM_KEY, NUM_SEMS, IPC_CREAT | IPC_EXCL | 0600)) == -1) {
	perror("creating sem"); exit(1); }
arg.val = 0;
if (semctl(semid, 0, SETVAL, arg) == -1) {
	perror("setting value, sem 0"); exit(1); }
arg.val = 20;
if (semctl(semid, 1, SETVAL, arg) == -1) {
	perror("setting value, sem 1"); exit(1); }
arg.array = semValues;
if (semctl(semid, 0, GETALL, arg) == -1) {
	perror("Getting values"); exit(1); }
for (count = 0; count < 2; count++)
	printf("sem id = %hu, value = %hu\n", count, semValues[count]);
while (1) {
        theSemOp.sem_num = 0;
	theSemOp.sem_op = -1;
	theSemOp.sem_flg = 0;
	if (semop(semid, &theSemOp, (size_t)1) == -1) {
		perror("semop"); exit(1); }
	if ((res = semctl(semid, 1, GETVAL, arg)) == -1)
		perror("getting value sem 1");
	printf("Semaphore 1 value is %d\n", res);
}
return 0;
}

