#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#define SHMEM_KEY ((key_t)2198)
#define SHMEM_SIZE 512

int main(void) {
int shmid;
char *shared_mem;

if ((shmid = shmget(SHMEM_KEY, SHMEM_SIZE, IPC_CREAT | IPC_EXCL | 0600)) == -1) {
	perror("creating shmem"); exit(1); }
if ((shared_mem = shmat(shmid, NULL, 0)) == NULL) {
	perror("attaching shmem"); exit(1);
}
*shared_mem = 0;
strcpy(shared_mem + 1, "mia papia mia poia papia");
*shared_mem = 1;
while (*shared_mem != 2)
	sleep(1);
printf("%s\n", shared_mem + 1);
if (shmdt(shared_mem) == -1) perror("detaching shared memory");
if (shmctl(shmid, IPC_RMID, 0) == -1) perror("removing shmem");
return 0;
}

