#include <stdio.h>
#include <signal.h>

void sigusr(int signo) {
if (signo == SIGUSR1) printf("Caught signal USR1\n");
else if (signo == SIGUSR2) printf("Caught signal USR2\n");
else fprintf(stderr, "Unknown signal %d in sigusr\n", signo);
return;
}

int main(void) {
int i;
printf("Signals example pid = %ld\n", (long)getpid());
if (signal(SIGUSR1, sigusr) == SIG_ERR)
	fprintf(stderr, "Cannot catch SIGUSR1\n");
if (signal(SIGUSR2, sigusr) == SIG_ERR)
	fprintf(stderr, "Cannot catch SIGUSR2\n");

for (i = 1; i < 20; i++)
	sleep(1);
return 0;
}
