#include <signal.h>
#include <stdio.h>

int main(void) {
sigset_t theSet, oldSet;
int i;

sigemptyset(&theSet);
sigaddset(&theSet, SIGINT);
puts("Blocking signal...");
sigprocmask(SIG_BLOCK, &theSet, &oldSet);
puts("Generating signal...");
raise(SIGINT);
puts("Querying pending signal...");
sigpending(&oldSet);
for (i = 1; i < NSIG; i++)
	if (sigismember(&oldSet, i)) {
		printf("%d\n", i);
		signal(i, SIG_IGN);
	}
puts("Unblocking signals...");
sigprocmask(SIG_UNBLOCK, &theSet, &oldSet);
return 0;
}


