#include <signal.h>
#include <stdio.h>

int main(void) {
sigset_t theSet, oldSet;

sigemptyset(&theSet);
sigaddset(&theSet, SIGINT);
sigaddset(&theSet, SIGFPE);
puts("Blocking signals...");
sigprocmask(SIG_BLOCK, &theSet, &oldSet);

puts("Generating signals...");
raise(SIGINT);
raise(SIGFPE);
puts("Waiting...");
sleep(5);
sigdelset(&theSet, SIGINT);
puts("Unblocking signals...");
sigprocmask(SIG_UNBLOCK, &theSet, &oldSet);
return 0;
}


