#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>



int main(int argc, char *argv[])
{
	int s, s1, res, name1_len;
	struct sockaddr_in name, name1;
	char buf[2 * BUFSIZ], *cp;

	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		fprintf(stderr, "%s: Cannot create a socket\n", argv[0]);
		exit(2);
	}
	name.sin_family = AF_INET;
	name.sin_addr.s_addr = INADDR_ANY;
	name.sin_port = 2412;
	if (bind(s, (struct sockaddr *)&name, sizeof(name)) < 0)
	{
		perror("Unable to bind socket");
		exit(3);
	}
	printf("Bound socket %d to port 2412\n", s);
	if (listen(s, 5) < 0)  { perror("listen() failed"); exit(2); }
	while (1)
	{
		name1_len = sizeof(name1);
		if ((s1 = accept(s, &name1, &name1_len)) < 0)
		{
			perror("accept() failed\n");
			break;
		}
		printf("Accepted con: %x.%x.%x.%x\n",
			name1.sin_addr.S_un._S_un_b.s_b1, name1.sin_addr.S_un._S_un_b.s_b2, name1.sin_addr.S_un._S_un_b.s_b3, name1.sin_addr.S_un._S_un_b.s_b4);

		while ((res = read(s1, buf, BUFSIZ)) > 0)
		{
			for (cp = buf; cp < buf + res; cp++)
				*cp = toupper(*cp);
			if (write(s1, buf, res) < 0)
			{
				perror("Error sending back data");
				break;
			}
		}
		close(s1);
	}
	close(s);
	return 0;
}

