#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

int main(int argc, char *argv[]) {
int i;
struct stat buf;
char *desc_str;

for (i = 1; i < argc; i++) {
	printf("%s: ", argv[i]);
	if (lstat(argv[i], &buf) == -1)
		desc_str = strerror(errno);
	else if (S_ISREG(buf.st_mode)) desc_str = "regular file";
	else if (S_ISDIR(buf.st_mode)) desc_str = "directory";
	else if (S_ISCHR(buf.st_mode)) desc_str = "character special";
	else if (S_ISBLK(buf.st_mode)) desc_str = "block special";
	else if (S_ISFIFO(buf.st_mode)) desc_str = "FIFO";
	else if (S_ISLNK(buf.st_mode)) desc_str = "symbolic link";
#ifdef S_ISSOCK
	else if (S_ISSOCK(buf.st_mode)) desc_str = "socket";
#endif
	else desc_str = "**Unknown mode**";
	printf("%s\n", desc_str);
}
return 0;
}
