#include <math.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>

int main(void) {
int fd, nbytes;
double theNumber, theSine;

if ((fd = open("sines.dat", O_WRONLY | O_CREAT | O_TRUNC, S_IRWXU)) == -1) {
	perror("opening sines.dat");
	exit(1);
}
for (theNumber = -M_PI; theNumber <= M_PI; theNumber += M_PI / 100) {
	theSine = sin(theNumber);
	if (write(fd, &theSine, sizeof(double)) < sizeof(double)) {
		perror("writing sines.dat");
		close(fd);
		exit(2);
	}
}
close(fd);
return 0;
}
