
// Edward Kmett

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUF_SIZE 4096

typedef unsigned int platter;

struct array_t {
        platter size, contents[];
};

typedef struct array_t * array;

array program;

size_t pc = 0;

platter reg[8] = {0,0,0,0,0,0,0,0};

inline array make(int x) {
        array result = (struct array_t *)calloc(x*sizeof(platter)+sizeof(struct array_t),1);
        result->size = x;
        return result;
}
inline array load(array a) {
        int sz = a->size*sizeof(platter)+sizeof(struct array_t);
        array result = (array)calloc(sz,1);
        return (array) memmove(result,a,sz);
}

void init(const char * filename) {
        unsigned char buf[BUF_SIZE];
        size_t n;
        int i;
        FILE * f = fopen(filename,"rb");
        printf("Reading %s...\n",filename);
        fseek(f,0,SEEK_END);
        program = make(ftell(f)/4+1);
        fseek(f,0,SEEK_SET);
        platter * c = program->contents;
        while ((n=fread(buf,1,BUF_SIZE,f))>0) {
                for (i=0;i<n;i+=4) {
                        *(c++) =
                        (((platter)buf[i])<<24)   +
                        (((platter)buf[i+1])<<16) +
                        (((platter)buf[i+2])<<8)  +
                        (((platter)buf[i+3]));
                }
        }
        fclose(f);
}

inline array p2a(platter i)     { return !i ? program : (array)i; }
inline platter a2p(array i)     { return i == program ? 0 : (platter)i; }

#define A reg[a]
#define B reg[b]
#define C reg[c]

void run() {
        while(1) {
                platter x = program->contents[pc++],
                        a = (x>>6)&7,
                        b = (x>>3)&7,
                        c = x&7;
                switch (x>>28) {
                case 0:  if (C) A=B; break;
                case 1:  A=p2a(B)->contents[C]; break;
                case 2:  p2a(A)->contents[B]=C; break;
                case 3:  A = B+C; break;
                case 4:  A = B*C; break;
                case 5:  A = B/C; break;
                case 6:  A = ~(B&C); break;
                case 7:  exit(0); break;
                case 8:  B = a2p(make(C)); break;
                case 9:  free(p2a(C)); break;
                case 10: fputc(C,stdout); break;
                case 11: C = (platter)fgetc(stdin); break;
                case 12: if (B) {
                                free(program);
                                program = load(p2a(B));
                         }
                         pc = C;
                         break;
                case 13: reg[(x>>25)&7] = x&0x01ffffff; break;
                default: perror("Unimplemented opcode");
                }
        }
}

int main(int argc, char ** argv) {
        setbuf(stdout,0);
        init(argc>1?argv[1]:"codex.umz");
        run();
}
