/*
 * Problems
 * --------
 * o. array[]s will point to memory outside of our segments somehow, under some circumstances
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <strings.h>
#include <time.h>
#include <strings.h>

//extern FILE *stdin;
//extern FILE *stdout;
//extern FILE *stderr;

int num_allocated_arrays = 100000;
int top_free_slot = 1;

unsigned int **array;
int *arraysizes;

int tracing = 0;
int debugging = 0;

void * callocr(int, int);

main(int argc, char* argv[]) {

    int ip = 0;
    unsigned int *mem;
    unsigned int regs[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    unsigned int i;
    unsigned int j;

    int fh;
    char * fn;
    struct stat fnstat;
    int filesize;

    int starttime;
    long long opsrun = 0;
    starttime = time(0);

    if(argc < 2) {
        printf("usage: %s <vmimage>\n", argv[0]); exit(1); 
    }

    for(i=1;i<argc;i++) { 
        if(!strcmp("--trace\000", argv[i])) { printf("tracing on\n"); tracing = 1; } 
        if(!strcmp("--debug\000", argv[i])) { printf("debugging on\n"); debugging = 1; } 
    }
    fn = argv[argc-1];

    char *ops[] = {
        "MVI", "LDR", "STO", "ADD", "MUL", "DIV", "NAD", "HLT", "ALC", "FRE", "OUT", "INP", "GTO", "LDI", "U14", "U15",
    };

    array = (unsigned int **) callocr(num_allocated_arrays, 4);
    arraysizes = (int *)callocr(num_allocated_arrays, 4);

    fh = open(fn, O_RDONLY);
    if(! fh) { perror("open"); exit(1); }

    //   int fstat(int filedes, struct stat *buf);
    if(fstat(fh, &fnstat)<0) perror("fstat");
    filesize = fnstat.st_size; 
    // printf("debug: filename: %s filesize: %d\n", fn, filesize);

    array[0] = (unsigned int *)calloc(filesize, 1); // bytes
    if(!array[0]) { perror("malloc"); exit(1); }
    arraysizes[0] = filesize/4; // words

    //   ssize_t read(int fd, void *buf, size_t count);
    if(! read(fh, array[0], filesize)) perror("read"); 
    for(i=0;i<filesize/4;i++) {  // words
        array[0][i] = ((array[0][i] & 0xff000000) >> 24) | ((array[0][i] & 0xff0000) >> 8) | ((array[0][i] & 0xff00) << 8) | ((array[0][i] & 0xff) << 24);
    }

    while(1) {

        int ins = array[0][ip];
        //int ins = ((ins1 & 0xff000000) >> 24) | ((ins1 & 0xff0000) >> 8) | ((ins1 & 0xff00) << 8) | ((ins1 & 0xff) << 24);
        int op = (ins & 0xf0000000) >> 28;
        int a;
        int b;
        int c;
        if(op == 13) {
            a = (ins & 0x0e000000) >> 25;
            b = (ins & 0x01ffffff);
            c = 0;
        } else {
            a  = (ins & 0x000001c0) >> 6;
            b  = (ins & 0x00000038) >> 3;
            c  = (ins & 0x00000007) >> 0;
        }

//if(opsrun % 100000 == 0) {
//    int timedelta = time(0) - starttime;
//    if(timedelta > 1) printf("ops per sec: %d timedelta: %d starttime: %d opsruns: %lld\n", (int)(opsrun / timedelta), timedelta, starttime, opsrun);
//}

        if(tracing) {
            printf("PC: %x (%d) %d REGS: %x %x %x %x %x %x %x %x\n", ip, ip, ip, regs[0], regs[1], regs[2], regs[3], regs[4], regs[5], regs[6], regs[7]);
            dumpop(op, &regs, a, b, c);
        }

        ip++;

        switch(op) {
            case 0: //MVI
                if(regs[c]) regs[a] = regs[b]; break;
            case 1: // LDR
                extendo(regs[b], regs[c]);
// if(regs[b]==143) printf("fetching from array 143 slot %d\n", regs[c]);
                regs[a] = array[regs[b]][regs[c]]; 
                break;
            case 2: // STO
                extendo(regs[a], regs[b]);
// if(regs[a]==143) printf("storing to array 143 slot %d\n", regs[b]);
                array[regs[a]][regs[b]] = regs[c]; 
                break;
            case 3: // ADD
                regs[a] = regs[b] + regs[c]; break;
            case 4: // MUL
                regs[a] = regs[b] * regs[c]; break;
            case 5: // DIV
                regs[a] = regs[b] / regs[c]; break;
            case 6: // NAD
                regs[a] = ~ ( regs[b] & regs[c] ); break;
            case 7: // HLT
                exit(0); 
            case 8: // ALC
                i = firstavailable();
// if(i==143) printf("allocated bank 143\n");
                regs[b] = i; 
                // j = regs[c];  // lies! abuse! torture!
                j = 16;
                array[i] = (unsigned int *) callocr(j, 4);  // words 
                arraysizes[i] = j;
                // num_allocated_arrays++;
                // if(debugging) printf("allocating an array of size %d for a total of %d allocated arrays\n", j, num_allocated_arrays);
                break;
            case 9: // FRE
                if(array[regs[c]]) {
                    free(array[regs[c]]); 
                } else {
                    // printf("bad attempt to free\n"); exit(1);
                }
                array[regs[c]] = 0; 
                arraysizes[regs[c]] = 0; 
                // num_allocated_arrays--;
                break;
            case 10: // OUT
                putchar(regs[c]); break;
            case 11: // INP
                regs[c] = getchar(); break;
            case 12: // GTO
                ip = regs[c];
                if(regs[b]) {
                    // if(debugging) printf("GTO executing, copy bank %d, size %d, into bank 0\n", regs[b], arraysizes[regs[b]]);
                    // printf("GTO executing, copy bank %d, size %d, into bank 0\n", regs[b], arraysizes[regs[b]]);
                    if(regs[b] >= top_free_slot) { printf("GTO accessing bank %d which is higher than last allocated %d\n", regs[b], top_free_slot); exit(1); } 
                    if(!arraysizes[regs[b]]) { printf("GTO non-allocated array\n"); exit(1); }
                    unsigned int **newarr = callocr(arraysizes[regs[b]], 4); // words  ########## XXXXXXXXXXXXXXXXXXXXXXXXXXXXX this is coredumping
                    // void *memcpy(void *dest, const void *src, size_t n);
                    bcopy(newarr, array[regs[b]], (size_t) arraysizes[regs[b]]*4);  // words
                    free(array[0]);
                    array[0] = newarr;
                    arraysizes[0] = arraysizes[regs[b]];
                }
                break;
            case 13: // LDI
                regs[a] = b; break;
            case 14: // unassigned
                break;
            case 15: // unassigned
                break;
        }
        opsrun++;
        // dumpop(op, &regs, a, b, c);
        // printf("\n");
    }

}

firstavailable() {
    if(top_free_slot >= num_allocated_arrays) {
        int siz = num_allocated_arrays + num_allocated_arrays/2;
// if(debugging) printf("debug: firstavailable had to run. existing size: %d existing cap: %d new size: %d num_allocated_arrays: %d\n", top_free_slot, num_allocated_arrays, siz);
printf("debug: firstavailable had to run. top_free_slot: %d num_allocated_arrays: %d siz: %d\n", top_free_slot, num_allocated_arrays, siz);
        unsigned int **newarray = (unsigned int **)callocr(siz, 4); // words
        int *newarraysizes = (int *)callocr(siz, 4); // words
        memcpy(newarray, array, num_allocated_arrays*4);  // words
        memcpy(newarraysizes, arraysizes, num_allocated_arrays*4);  // words
        free(array);
        free(arraysizes);
        num_allocated_arrays = siz;
        array = newarray;
        arraysizes = newarraysizes;
    }
    return top_free_slot++;
}

extendo(int index1, int index2) {
    // extend array[index1] to be of size index2
    //            if(arraysizes[regs[b]] < regs[b]) extendo(&array, regs[b], regs[c]);
    if(arraysizes[index1] > index2) return;
    index2 += index2/2; if(index2 < 32) index2 += 32; // over-allocate
    if(debugging) printf("debug: extendo had to run. bank: %d existing size: %d new size: %d num_allocated_arrays: %d\n", index1, arraysizes[index1], index2, num_allocated_arrays);
    // if(index1 == 143) printf("debug: extendo had to run. bank: %d existing size: %d new size: %d num_allocated_arrays: %d\n", index1, arraysizes[index1], index2, num_allocated_arrays);
    unsigned int *newarray = (unsigned int *)callocr(index2, 4); // words
    memcpy(newarray, array[index1], (size_t) arraysizes[index1]*4);  // words
    free(array[index1]);
    array[index1] = newarray;
    arraysizes[index1] = index2;
}

void * callocr(int num, int siz) {
    void * ret = (void *)calloc(num, siz);
    if(!ret) { fprintf(stderr, "during request for %d byte... "); perror("calloc"); *(int *)0=1; }
}

dumpop(int op, unsigned int *regs, int a, int b, int c) {
    switch(op) {
        case 0:
            printf("MVI r%d (%x) <- r%d (%x) if r%d (%x)\n", a, regs[a], b, regs[b], c, regs[c] ); break;
        case 1:
            printf("LDR r%d (%x) <- r%d (%x)[r%d (%x)]\n", a, regs[a], b, regs[b], c, regs[c] ); break;
        case 2:
            printf("STO r%d (%x) [r%d (%x)] <- r%d (%x)\n", a, regs[a], b, regs[b], c, regs[c] ); break;
        case 3:
            printf("ADD r%d (%x) <- r%d (%x), r%d (%x)\n", a, regs[a], b, regs[b], c, regs[c] ); break;
        case 4:
            printf("MUL r%d (%x) <- r%d (%x), r%d (%x)\n", a, regs[a], b, regs[b], c, regs[c] ); break;
        case 5:
            printf("DIV r%d (%x) <- r%d (%x), r%d (%x)\n", a, regs[a], b, regs[b], c, regs[c] ); break;
        case 6:
            printf("NAD r%d (%x) <- r%d (%x), r%d (%x)\n", a, regs[a], b, regs[b], c, regs[c] ); break;
        case 7:
            printf("HLT\n"); break;
        case 8:
            printf("ALC r%d (%x) <- bank->(r%d (%x))\n", b, regs[b], c, regs[c] ); break;
        case 9:
            printf("FRE r%d (%x)\n", c, regs[c] ); break;
        case 10:
            printf("OUT r%d (%x)\n", c, regs[c] ); break;
        case 11:
            printf("INP r%d (%x)\n", c, regs[c] ); break;
        case 12:
            printf("GTO bank r%d (%x) offset r%d (%x)\n", b, regs[b], c, regs[c] ); break;
        case 13:
            printf("LDI r%d <- #%d\n", a, b ); break;
    }
}

//        } elsif(op == 13) {
//            printf("%8x:     %3s r%x(%x), #%x             [lit: %8x]\n", ip, ops[op], a, regs[a], b, ins);
//        } else { 
//            printf("%8x:     %3s r%x(%x),r%x(%x),r%x(%x)  [lit: %8x]\n", ip, ops[op], a, regs[a], b, regs[b], c, regs[c], ins);
//        }

//        printf STDERR "PC: %x (%d) $self->{pc} REGS: %x %x %x %x %x %x %x %x\n",
//          $self->{pc}, $self->{pc}, @{$self->{reg}};

//    $a = sprintf "r%d (%x)", $a, $self->{reg}[$a];
//    if($op != 13) {


/* 
    #            #0. Conditional Move.
    # 
    #                   The register A receives the value in register B, unless
    #                   the register C contains 0.

    #            #1. Array Index.
    # 
    #                   The register A receives the value stored at offset in
    #                   register C in the array identified by B.

    #            #2. Array Amendment.
    # 
    #                   The array identified by A is amended at the offset in
    #                   register B to store the value in register C.

    #            #3. Addition.
    # 
    #                   The register A receives the value in register B plus the
    #                   value in register C, modulo 2^32.
    
    #            #4. Multiplication.
    # 
    #                   The register A receives the value in register B times the
    #                   value in register C, modulo 2^32.
    
    #            #5. Division.
    # 
    #                   The register A receives the value in register B divided
    #                   by the value in regisetr C, if any, where each quantity
    #                   is treated treated as an unsigned 32 bit number.
    
    #            #6. Not-And.
    # 
    #                   Each bit in the register A receives the 1 bit if either
    #                   register B or register C has a 0 bit in that position.
    #                   Otherwise the bit in register A receives the 0 bit.

    #            #7. Halt.
    # 
    #                   The universal machine stops computation.

    #            #8. Allocation.
    # 
    #                   A new array is created with a capacity of platters
    #                   commensurate to the value in the register C. This new
    #                   array is initialized entirely with platters holding the
    #                   value 0. A bit pattern not consisting of exclusively the
    #                   0 bit, and that identifies no other active allocated
    #                   array, is placed in the B register.

    #            #9. Abandonment.
    # 
    #                   The array identified by the register C is abandoned.
    #                   Future allocations may then reuse that identifier.

    #           #10. Output.
    # 
    #                   The value in the register C is displayed on the console
    #                   immediately. Only values between and including 0 and 255
    #                   are allowed.

    #           #11. Input.
    # 
    #                   The universal machine waits for input on the console.
    #                   When input arrives, the register C is loaded with the
    #                   input, which must be between and including 0 and 255.  If
    #                   the end of input has been signaled, then the register C
    #                   is endowed with a uniform value pattern where every place
    #                   is pregnant with the 1 bit.

    #           #12. Load Program.
    # 
    #                   The array identified by the B register is duplicated and
    #                   the duplicate shall replace the '0' array, regardless of
    #                   size. The execution finger is placed to indicate the
    #                   platter of this array that is described by the offset
    #                   given in C, where the value 0 denotes the first platter,
    #                   1 the second, et cetera.
    # 
    #                   The '0' array shall be the most sublime choice for
    #                   loading, and shall be handled with the utmost velocity.

    #   #13. Immediate Load

  */
