%{
#include <stdio.h>
#include <stdlib.h>

#include "ast.h"            /* "ast.h" must be BEFORE "parser.h" */
#include "parser.h"
#define T_eof      0

void yyerror (const char * msg);
%}

D [0-9]
L [a-z]
W [ \t\r\n]

%%

"print" { return T_print; }
"let"   { return T_let; }
"for"   { return T_for; }
"do"    { return T_do; }
"begin" { return T_begin; }
"end"   { return T_end; }
"if"    { return T_if; }
"then"  { return T_then; }

{D}+    { yylval.num = atoi(yytext); return T_const; }
{L}     { yylval.var = yytext[0] - 'a'; return T_var; }

[=\(\)\+\-\*] { return yytext[0]; }

{W}+    { /* nothing */ }
\'.*\n  { /* nothing */ }

<<EOF>> { return T_eof; }
.       { yyerror("lexical error"); exit(1); }

%%
