%{
#include <stdio.h>
#include <stdlib.h>
#include "ast.h"

AST prg;

void yyerror (const char * msg);
%}

%union{
  AST ast;
  number num;
  variable var;
}

%token T_print "print"
%token T_let "let"
%token T_for "for"
%token T_do "do"
%token T_begin "begin"
%token T_end "end"
%token T_if "if"
%token T_then "then"

%token<num> T_const
%token<var> T_var

%left '+' '-'
%left '*'

%type<ast> stmt_list
%type<ast> stmt
%type<ast> expr

%%

program   : stmt_list                { prg = $1; }
          ;

stmt_list : /* nothing */            { $$ = NULL; }
          | stmt stmt_list           { $$ = ast_node(T_begin, $1, $2); }
          ;

stmt      : "print" expr             { $$ = ast_node(T_print, $2, NULL); }
          | "let" T_var '=' expr     { $$ = ast_let($2, $4); }
          | "for" expr "do" stmt     { $$ = ast_node(T_for, $2, $4); }
          | "begin" stmt_list "end"  { $$ = $2; }
          | "if" expr "then" stmt    { $$ = ast_node(T_if, $2, $4); }
          ;

expr      : T_const                  { $$ = ast_num($1); }
          | T_var                    { $$ = ast_var($1); }
          | '(' expr ')'             { $$ = $2; }
          | expr '+' expr            { $$ = ast_node('+', $1, $3); }
          | expr '-' expr            { $$ = ast_node('-', $1, $3); }
          | expr '*' expr            { $$ = ast_node('*', $1, $3); }
          ;

%%

void yyerror (const char * msg)
{
  fprintf(stderr, "Minibasic: %s\n", msg);
  exit(1);
}

int main ()
{
  int result = yyparse();
  if (result == 0) interpret(prg);
  return result;
}
