%{
#include <stdio.h>
#include <stdlib.h>

#define T_eof      0
#define T_print 1000
#define T_let   1001
#define T_for   1002
#define T_do    1003
#define T_begin 1004
#define T_end   1005
#define T_if    1006
#define T_then  1007
#define T_const 1008
#define T_var   1009
%}

D [0-9]
L [a-z]
W [ \t\r\n]

%%

"print" { return T_print; }
"let"   { return T_let; }
"for"   { return T_for; }
"do"    { return T_do; }
"begin" { return T_begin; }
"end"   { return T_end; }
"if"    { return T_if; }
"then"  { return T_then; }

{D}+    { return T_const; }
{L}     { return T_var; }

[=\(\)\+\-\*] { return yytext[0]; }

{W}+    { /* nothing */ }
\'.*\n  { /* nothing */ }

<<EOF>> { return T_eof; }
.       { fprintf(stderr, "Lexical error\n");
          exit(1); }

%%

int main ()
{
  int token;

  do {
    token = yylex();
    printf("token=%d, lexeme=\"%s\"\n",
           token, yytext);
  } while (token != T_eof);
  return 0;
}
