%{
#include <stdio.h>
#include <stdlib.h>

void yyerror (const char * msg);
%}

%token T_print "print"
%token T_let "let"
%token T_for "for"
%token T_do "do"
%token T_begin "begin"
%token T_end "end"
%token T_if "if"
%token T_then "then"

%token T_const
%token T_var

%left '+' '-'
%left '*'

%%

program   : stmt_list
          ;

stmt_list : /* nothing */
          | stmt stmt_list
	  ;

stmt      : "print" expr
          | "let" T_var '=' expr
  	  | "for" expr "do" stmt
	  | "begin" stmt_list "end"
	  | "if" expr "then" stmt
	  ;

expr      : T_const
          | T_var
	  | '(' expr ')'
	  | expr '+' expr
	  | expr '-' expr
	  | expr '*' expr
	  ;

%%

void yyerror (const char * msg)
{
  fprintf(stderr, "Minibasic: %s\n", msg);
  exit(1);
}

int main ()
{
  return yyparse();
}
