library IEEE;
use IEEE.std_logic_1164.all;

entity alu_tb is
end alu_tb;
                              
architecture tb_arch of alu_tb is
  -- Component declaration of the DUT
  component alu
    port (
      a,b : in std_logic_vector(7 downto 0);
      cin : in std_logic;
      sel : in std_logic_vector(3 downto 0);
      y   : out std_logic_vector(7 downto 0)
    );
  end component;
  --
  -- Signal declarations
  signal a   : std_logic_vector(7 downto 0);
  signal b   : std_logic_vector(7 downto 0);
  signal cin : std_logic;
  signal sel : std_logic_vector(3 downto 0);
  signal y   : std_logic_vector(7 downto 0);
  --
  -- Constant declarations
  constant CLK_PERIOD : time := 50 ns;
begin

  -- Unit Under Test port map
  UUT : alu
    port map (
      a  => a,
      b  => b,
      cin => cin,
      sel => sel,
      y => y
    );

  DATA_STIM: process
  begin
    a <= X"93"; b <= X"A7"; cin <= '0'; sel <= "0000";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0001";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0010";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0011";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0100";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0101";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0110";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0111";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1000";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1001";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1010";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1011";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1100";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1101";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1110";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "1111";
    wait for CLK_PERIOD;
    --
    a <= X"93"; b <= X"A7"; cin <= '0';	sel <= "0000";
    wait for CLK_PERIOD;
    --
  end process DATA_STIM;

end tb_arch;
