library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity alu is
  port (
    a,b : in std_logic_vector(7 downto 0);
    cin : in std_logic;
    sel : in std_logic_vector(3 downto 0);
    y : out std_logic_vector(7 downto 0)
  );
end alu;

architecture dataflow of alu is
  signal arith: std_logic_vector(7 downto 0);
  signal logic: std_logic_vector(7 downto 0);
begin
  -- Arithmetic unit
  with sel(2 downto 0) select
    arith <= a when "000",
             a+1 when "001",
             a-1 when "010",
             b when "011",
             b+1 when "100",
             b-1 when "101",
             a+b when "110",
             a+b+cin when "111";

  -- Logic unit
  with sel(2 downto 0) select
    logic <= not a when "000",
             not b when "001",
             a and b when "010",
             a or b when "011",
             a nand b when "100",
             a nor b when "101",
             a xor b when "110",
             a xnor b when "111";

  -- Multiplexer
  with sel(3) select
    y <= arith when '0',
         logic when others;

end dataflow;
