library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity ram_sync is
  port (
    clk, we : in  std_logic;
    rwaddr  : in  std_logic_vector(5 downto 0);
    di      : in  std_logic_vector(15 downto 0);
    do      : out std_logic_vector(15 downto 0)
  );
end ram_sync;

architecture synth of ram_sync is
  type ram_type is array (63 downto 0) of std_logic_vector(15 downto 0);
  signal RAM: ram_type;
begin
  process (clk)
  begin
    if (clk='1' and clk'EVENT) then
      if (we = '1') then
        RAM(conv_integer(rwaddr)) <= di;
      end if;
      do <= RAM(conv_integer(rwaddr));
    end if;
  end process;
end synth;
