// =============================================================
// File:     WHConechoice.js
// Contents: Basic scripts used for one-choice activities
// Revised:  2-July-1999
// Copyright (c) 1997-1999 William Horton Consulting, Inc.
// =============================================================

function hOneChoice() {
	this.ID = null          // Unique identifier for this question
	this.intro = ""               // Introductory text, usually the question itself
	this.parent = null
	this.possiblescore = 0        // Highest possible score
	this.messageRight = ""
	this.messageWrong = ""
	this.messageHint = ""
	this.answers = new Array()     // Answer objects (zero-based)
	this.currentAnswer = -1
	// this.correctAnswer = 0
	this.showAnswers = oneChoiceShowAnswers
	this.reset = oneChoiceReset
	this.generateDisplay = oneChoiceGenerateDisplay
	this.addAnswer = oneChoiceAddAnswer
	this.setAnswers = oneChoiceSetAnswers
	this.setFlags = oneChoiceSetFlags
	this.saveAnswers = oneChoiceSaveAnswers
	this.generateFeedback = oneChoiceGenerateFeedback
	this.markAnswers = oneChoiceMarkAnswers
	this.generateScore = oneChoiceGenerateScore
	this.makeRow = oneChoiceMakeRow
}


function oneChoiceGenerateDisplay(){
	var theHTML = ""
	//theHTML += "<DIV ALIGN='CENTER'>"
	//theHTML += "<TABLE border='0' width='100%'><TR><TD>"
	theHTML += "<p>" + this.intro + "</p>"
	theHTML += "<form name='Frm" + this.ID + "'>\r"
	theHTML += "<DIV ALIGN='CENTER'>"
	theHTML += "<table border='0' width='100%'>\r"
	for (var i=0; i< this.answers.length; i++) {
		theHTML += this.makeRow(i, this.answers[i], this.ID)
	}
	theHTML += "</table></div></form></p><br>\r"
	if ((this.parent.type == "test") && (this.parent.showFeedback)) {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback())
	}
	//theHTML += "</TD></TR></TABLE></DIV>"
	return theHTML
}

function oneChoiceMarkAnswers() {
	var	theAnswer = this.currentAnswer
	var myForm = document.forms[this.ID]
	resetFlags(this.ID, this.answers.length)
	if (theAnswer == (this.correctAnswer)) {
		document.images["Img" + this.ID + (theAnswer-1)].src="art/testscoreright.gif" + "\r"
		alert ("The correct answer =" + this.correctAnswer)
	}  else {		
		if (theAnswer != 0) {
			document.images["Img" + this.ID + (theAnswer-1)].src="art/testscorewrong.gif"
			document.images["Img" + this.ID + (this.correctAnswer - 1)].src="art/testscoreright.gif"
		} 
	}	
}

function oneChoiceGenerateFeedback() {
	var myFeedback = ""
	var rightWrongMessage = this.messageWrong + "\r"
	var explanatoryMessage = ""
	for (i=0; i<this.answers.length; i++) {
		thisAnswer = this.answers[i]
		if (thisAnswer.chosen) {
			explanatoryMessage += thisAnswer.feedback + "\r"
			if (thisAnswer.isRight) { // right answer was chosen
				rightWrongMessage = this.messageRight + "\r"
			} 
		}
	}
	myFeedback += rightWrongMessage + explanatoryMessage
	myFeedback += "Score: " + this.generateScore() + " of " + this.possibleScore + " points.\r"

	return myFeedback
} 

function oneChoiceShowAnswers() {
	this.setAnswers("Right")
	this.setFlags("Score")
	var myFeedback = this.generateFeedback()
	return myFeedback
}

function oneChoiceSetAnswers(typeAction) {
	// alert("In oneChoiceSetAnswers() with typeAction = " + typeAction)
	if (typeAction == "Initial") {
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].checked = this.answers[i].initiallyChosen
			this.answers[i].chosen = this.answers[i].initiallyChosen
		}
	} else if (typeAction == "Current") {
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].checked = this.answers[i].chosen
		}
	} else if (typeAction == "Right") {
			for (i=0; i<this.answers.length; i++) {
				document.forms["Frm" + this.ID].elements[i].checked = this.answers[i].isRight
				this.answers[i].chosen = this.answers[i].isRight
			}
	} else {
		alert("oneChoiceSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
}

function oneChoiceSetFlags(typeAction) {
	// alert ("In oneChoiceSetFlags with typeAction = " + typeAction)
	if (typeAction == "Clear") {
		for (i=0; i<this.answers.length; i++) {
			document.images["Img" + this.ID + i].src="art/testscorenone.gif"
		}
	} else if (typeAction == "Score") {
		for (i=0; i<this.answers.length; i++) {
			if (this.answers[i].isRight) { // right answer
				if (this.answers[i].chosen) {  // right answer chosen
					document.images["Img" + this.ID + i].src="art/testscoreright.gif" + "\r"
				} else {  // right answer unchosen
					document.images["Img" + this.ID + i].src="art/testscoreright_red.gif" + "\r"	
				}
			} else { // wrong answer
					if (this.answers[i].chosen) {  // wrong answer chosen
					document.images["Img" + this.ID + i].src="art/testscorewrong.gif" + "\r"
				} else {  // wrong answer unchosen
					document.images["Img" + this.ID + i].src="art/testscorenone.gif" + "\r"	
				}
			}
		}
	} else {
			alert("oneChoiceSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}


function oneChoiceReset(){
	// Make generic?
	this.setFlags("Clear")
	this.setAnswers("Initial")
}

function oneChoiceAddAnswer(theAnswer) {
	// Make generic?
	if (theAnswer != null) {
		this.answers[this.answers.length] = theAnswer
	}
}

// Constructs the specific rows of the test initially.
function oneChoiceMakeRow(rowNum, theAnswer, theID) {

	theImg = "art/testscorenone.gif"

	theRow = "<tr>\r"
	
	theRow += "   <td width='2%' align='left' valign='top'><img name=\"Img" + theID + rowNum + "\" "
	theRow += "src=\"" + theImg + "\"></td>\r"
	
	theRow += "   <td width='2%' valign=\"top\"><input type='radio' name='Radio" + theID + "' "
	theRow += "value='Radio" + this.ID + rowNum + "' onClick='theTest.questions[" + theID +"].saveAnswers()'"
	
	theRow += "></td>\r"
	
	theRow +="   <td width='50%'><FONT class='TableData'>" + theAnswer.text + "</td>\r"
	
	theRow += "</tr>\r"
	return theRow
}

function oneChoiceSaveAnswers() {
	for (i = 0; i < this.answers.length; i++) {
		this.answers[i].chosen = document.forms["Frm" + this.ID].elements[i].checked
		if (this.answers[i].chosen) {
			this.currentAnswer = i
		}
	}
}

function oneChoiceGenerateScore() {
	// This function uses the fraction of right answers rather than points for each answer.
	var theScore = 0
	var theAnswer
	var rightAnswers = 0
	for (i=0; i < this.answers.length; i++) {
		theAnswer = this.answers[i]
		if (theAnswer.isRight && theAnswer.chosen) {
			theScore = this.possibleScore
		}
	}
	return theScore
}