// =============================================================
// File:     WHCtextentry.js
// Contents: Basic scripts used for text-entry activities
// Revised:  2-July-1999
// Copyright (c) 1997-1999 William Horton Consulting, Inc.
// =============================================================

function hTextEntry() {
	this.ID = null          // Unique identifier for this question
	this.parent = null
	this.intro = ""               // Introductory text, usually the question itself
	this.possibleScore = 0        // Highest possible score
	this.messageRight = ""
	this.messageWrong = ""
	this.messageHint = ""
	// Answer is built in
	// this.questionText = ""
	this.rows = 3
	this.columns = 100
	this.initialAnswer = "Type your answer here."
	this.rightAnswer = ""
	this.rightAnswerPatternArray = null       // Array of regular expressions (text, not objects)
	this.numberPatternsThatMustMatch = 1      // How many must match for a correct answer
	this.allowPartialCredit = false           // Whether to award points for fraction of right answers
	this.currentAnswer = ""
	// this.answers = new Array()     // Answer objects (zero-based)
	this.isAnswerRight = textEntryIsAnswerRight
	this.showAnswers = textEntryShowAnswers
	this.reset = textEntryReset
	this.generateDisplay = textEntryGenerateDisplay
	// this.addAnswer = textEntryAddAnswer
	this.setAnswers = textEntrySetAnswers
	this.setFlags = textEntrySetFlags
	this.saveAnswers = textEntrySaveAnswers
	this.generateFeedback = textEntryGenerateFeedback
	this.generateScore = textEntryGenerateScore
}

function textEntryGenerateDisplay(){
	var theHTML = ""
	if (this.intro.length > 0) {
		theHTML += "<p>" + this.intro + "</p>"
	}
	theHTML += "<p>" + this.questionText + "</p>"
	theHTML += "<form name='Frm" + this.ID + "'>\r"
	theHTML += "<table border='0' width='95%'>\r"
	theHTML += "<tr><td width='2%' align='left' valign='top'>\r"
	theHTML += "<img name='Img" + this.ID + "' "
	theHTML += "src='art/testscorenone.gif'></td>\r"
	
	theHTML += "<td width='93%'>"
	theHTML += "<textarea name='Text" + this.ID + "' rows='" + this.rows + "' "
	theHTML += "cols='" + this.columns + "' wrap='virtual' "
	theHTML += "onChange='theTest.questions[" + this.ID + "].saveAnswers()'>"
	theHTML += this.initialAnswer + "</textarea>"
	
	theHTML += "</td>"
	theHTML += "</tr></table></form>"
	if ((this.parent.type == "test") && (this.parent.showFeedback)) {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback())
	}
	return theHTML
}

function textEntryIsAnswerRight() {
	var theResult = false
	// Put in a more sophisticated matching later
	var numMatches = theTest.getNumTextMatches(this.currentAnswer, this.rightAnswerPatternArray)
	if (numMatches >= this.numberPatternsThatMustMatch){
		return true
	} else {
		return false
	}
}

function textEntryGenerateFeedback() {
	// alert(this.ID + ": textEntryGenerateFeedback()")
	var myFeedback = ""
	var numMatches = theTest.getNumTextMatches(this.currentAnswer, this.rightAnswerPatternArray)
	if (this.isAnswerRight()) {
		myFeedback = this.messageRight + "\r"
		// myFeedback += " You matched all the required items."
	} else {
		myFeedback += this.messageWrong + "\r"
		myFeedback += "You matched " + numMatches + " of the required " 
		myFeedback += this.numberPatternsThatMustMatch + " items." + "\r"
	} 
	myFeedback += "Score: " + this.generateScore() + " of " + this.possibleScore + " points." + "\r"
	return myFeedback
}

function textEntryShowAnswers(){
	// Make this generic?
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function textEntrySetAnswers(typeAction) {
	// alert("textEntrySetAnswers('" + typeAction + "')")
	var theAnswer
	if (typeAction == "Initial") {theAnswer = this.initialAnswer}
	else if (typeAction == "Current")  {theAnswer = this.currentAnswer}
	else if (typeAction == "Right")  {theAnswer = this.rightAnswer}
	else {
		 // alert("textEntrySetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
	this.currentAnswer = theAnswer
	// alert("Setting form field to " + this.currentAnswer)
	document.forms["Frm" + this.ID].elements[0].value = theAnswer
}

function textEntrySetFlags(typeAction) {
	// alert ("In textEntrySetFlags with typeAction = " + typeAction)
	if (typeAction == "Clear") {
		document.images["Img" + this.ID].src="art/testscorenone.gif"
	} else if (typeAction == "Score") {
		if (this.isAnswerRight()) {
			document.images["Img" + this.ID].src="art/testscoreright.gif"
		} else {
			document.images["Img" + this.ID].src="art/testscorewrong.gif"
		}
	} else {
		 alert("textEntrySetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function textEntryReset(){
	// Make generic?
	// alert("In textEntryReset() in Question " + this.ID)
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function textEntrySaveAnswers() {	
	this.currentAnswer = document.forms["Frm" + this.ID].elements[0].value
	// alert("textEntrySaveAnswers() with this.currentAnswer = " + this.currentAnswer)
}
	
	
function textEntryGenerateScore() {
	// Can implement mechanism for partial credit based on number of patterns that match
	if (this.allowPartialCredit) { // Points for each answer correct
		var numMatches = theTest.getNumTextMatches(this.currentAnswer, this.rightAnswerPatternArray)
		// alert("numMatches = " + numMatches)
		return parseInt(this.possibleScore * (numMatches/this.numberPatternsThatMustMatch))
	} else { // All or nothing
		if (this.isAnswerRight()) {
			return this.possibleScore
		} else {
			return 0
		}
	}
}
