
// =============================================================
// File:     WHCcrossword.js
// Contents: Basic scripts used for crossword puzzle activities
// Revised:  9-August-1999
// Copyright (c) 1997-1999 William Horton Consulting, Inc.
// =============================================================

function hCrossword() {
	this.ID = null          // Unique identifier for this question
	this.parent = null
	this.intro = ""               // Introductory text, usually the question itself
	this.possibleScore = 0        // Highest possible score
	this.minimumScore = 0
	this.messageRight = ""
	this.messageWrong = ""
	// Specific properties
	this.imageWidth = 30
	this.imageHeight = 30
	this.numRows = 10
	this.numCols = 10
	this.imagePath = "art/"
	this.board = new Array()
	this.clues = new Array()
	this.currentAnswers= new Array()
	this.correctAnswers = new Array()
	this.currentClue = -1
	// Methods
	this.showAnswers = crosswordShowAnswers
	this.reset = crosswordReset
	this.generateDisplay = crosswordGenerateDisplay
	this.setAnswers = crosswordSetAnswers
	this.setFlags = crosswordSetFlags
	this.saveAnswers = crosswordSaveAnswers
	this.generateFeedback = crosswordGenerateFeedback
	this.generateScore = crosswordGenerateScore
	this.addClue = crosswordAddClue
	this.makeBoard = crosswordMakeBoard
	this.makeBoardDisplay = crosswordMakeBoardDisplay
	this.makeClueList = crosswordMakeClueList
	this.getIndexForRowCol = crosswordGetIndexForRowCol
	this.getRowColForIndex = crosswordGetRowColForIndex
	this.getNextIndex = crosswordGetNextIndex
	this.postAnswer = crosswordPostAnswer
	this.setCurrentClue = crosswordSetCurrentClue
	this.processGuess = crosswordProcessGuess
	this.eraseCurrentAnswers = crosswordEraseCurrentAnswers
	this.makeCorrectAnswers = crosswordMakeCorrectAnswers
}

function clue(itsNumber, direction, row, column, answer, clue) {
	this.number = itsNumber
	this.direction = direction
	this.row = row
	this.col = column
	this.clue = clue
	this.answer = answer.toLowerCase()
}

function crosswordAddClue(theClue) {
	this.clues[this.clues.length] = theClue
}

function crosswordMakeBoard() {
	for (var i=1; i<= this.numRows * this.numCols; i++) {
		this.board[i-1] = "b" // Blackens all squares
	}
	for (var i = 0; i < this.clues.length ; i++) {
		// alert("this.clues[" + i + "].row = " + this.clues[i].row + "\rthis.clues[" + i + "].col = " + this.clues[i].col)
		var cellIndex = this.getIndexForRowCol(this.clues[i].row, this.clues[i].col)
		// alert("cellIndex = " + cellIndex)
		this.board[cellIndex] = this.clues[i].number
		for (var j=1; j< this.clues[i].answer.length; j++) {
			nextCellIndex = this.getNextIndex(cellIndex, this.clues[i].direction)
			// alert("nextCellIndex = " + nextCellIndex)
			if (nextCellIndex == -1) {
				var theMsg = "Error in clue " + this.clues[i].number + " " 
				theMsg += this.clues[i].direction + ": Answer is too long."
				theMsg += "\rcellIndex = " + cellIndex + "\rnextCellIndex = " + nextCellIndex
				alert(theMsg)
				return
			} else {
				cellIndex = nextCellIndex
				this.board[cellIndex] = "w"
			}
		}
	}		
}


function crosswordMakeBoardDisplay() {
	this.makeBoard()
	var myHTML = ""
	myHTML += "<table border=0 bgcolor='#BBBBBB' cellspacing='5' cellpadding='0'><TR><TD>"
	myHTML += "<table border=0 bgcolor='#BBBBBB' cellspacing='3' cellpadding='0'>"
	for (var theRow = 1; theRow <= this.numRows; theRow++) {
		myHTML += "<tr>"
		for (var theCol = 1; theCol <= this.numCols; theCol++) {
			theIndex = this.getIndexForRowCol(theRow, theCol)
			if (this.board[theIndex] == "b") {
				myGraphic = this.imagePath + "black.gif" 
			} else if (this.board[theIndex] == "w") {
				myGraphic = this.imagePath + "white.gif"
			} else {
				myGraphic = this.imagePath + this.board[theIndex] + ".gif"
			}
			myHTML += "<td background='" + myGraphic + "' "
			myHTML += "height='" + this.imageHeight + "' width='" + this.imageHeight + "'>"
			myHTML += "<img name='Xword" + this.ID + "Cell" + theIndex + "' "
			myHTML += "src='" + myGraphic + "' "
			myHTML += "width='" + this.imageWidth + "' height='" + this.imageHeight + "'>"
			myHTML += "</td>"
		}
		myHTML += "</tr>"
	}
	myHTML += "</table></td></TR></TABLE>"
	return myHTML	
}

function crosswordPostAnswer(clueIndex, theAnswer, whichArray) {
	var startBoardIndex = this.getIndexForRowCol(this.clues[clueIndex].row, this.clues[clueIndex].col)
	if (theAnswer.length > this.clues[clueIndex].answer.length) {
		alert("Your answer '" + theAnswer + "' is longer than the available slot. It has been shortened to fit.")
		theAnswer = theAnswer.substring(0,this.clues[clueIndex].answer.length)
	}
	var theDirection = this.clues[clueIndex].direction
	var startRow = this.clues[clueIndex].row
	var startCol = this.clues[clueIndex].col
	var cellIndex = this.getIndexForRowCol(startRow, startCol)
	theAnswer = theAnswer.toLowerCase()
	for (var i = 0; i < theAnswer.length; i++) {
		theChar = theAnswer.charAt(i)
		if (whichArray == "current") {
			this.currentAnswers[cellIndex] = theChar
			document.images["Xword" + this.ID + "Cell" + cellIndex].src=this.imagePath + theChar + ".gif"
		} else {
			this.correctAnswers[cellIndex] = theChar
		}
		cellIndex = this.getNextIndex(cellIndex, theDirection)
	}
}


function crosswordGetIndexForRowCol(row, col) {
	return (col - 1) + (row - 1) * (this.numCols)
}

function crosswordGetNextIndex(startingIndex, direction) { 
	if (direction == "across") {
		var currentCol = this.getRowColForIndex(startingIndex, "col")
		if (currentCol == this.numCols) { // Already in last col
			return -1
		} else { 	
			return startingIndex + 1
		}
	} else { // direction is down
		var currentRow = this.getRowColForIndex(startingIndex, "row")
		if (currentRow == this.numRows) { // Already in last row
			return -1
		} else { 	
			return startingIndex + this.numCols
		}	
	}
}
	
function crosswordGetRowColForIndex(index, itemDesired) {
	if (itemDesired == "col") {
		return 1 + index % this.numCols
	} else {
		return 1 + parseInt(index/this.numCols)
	}
}

function crosswordMakeClueList() {
	var myHTML = ""
	myHTML += "<select name='Clues' "
	myHTML += "onChange='theTest.questions[" + this.ID + "].setCurrentClue()'>"
	myHTML += "<option value='label' SELECTED>Pick the clue you want to answer.</option>"
	myHTML += "<option value='label'>================ ACROSS =================</option>"
	for (var i = 0; i < this.clues.length; i++) {
		if (this.clues[i].direction == "across") {
			myHTML += "<option value='" + i + "'>" + this.clues[i].number + " Across.&nbsp;&nbsp;"
			myHTML += this.clues[i].clue + "</option>"
		}
	}
	myHTML += "<option value='label'>================ DOWN ==================</option>"
	for (var i = 0; i < this.clues.length; i++) {
		if (this.clues[i].direction == "down") {
			myHTML += "<option value='" + i + "'>" + this.clues[i].number + " Down.&nbsp;&nbsp;"
			myHTML += this.clues[i].clue + "</option>"
		}
	}
	myHTML += "</select>"
	return myHTML
}

function crosswordSetCurrentClue() {
	// alert("This ID = " + this.ID)
	var selIndex = document.forms["Frm" + (this.ID + 1)].Clues.selectedIndex
	var selValue = document.forms["Frm" + (this.ID + 1)].Clues.options[selIndex].value
	if (selValue == "label"){ selValue = -1 }
	this.currentClue = selValue
	document.forms["Frm" + (this.ID + 1)].Guess.focus()
	document.forms["Frm" + (this.ID + 1)].Guess.select()
	// alert("this.currentClue = " + this.currentClue)
}

function crosswordProcessGuess() {
	if (this.currentClue == -1) {
		alert("Please select a clue first.")
	} else {
		this.postAnswer(this.currentClue, document.forms["Frm" + (this.ID + 1)].Guess.value, "current")
	}
}

function preloadGraphics(maxNumber, imagePath) {
	this.images = new Array()
	
	var graphicsList = new Array("blank.gif", "blankWrong.gif", "white.gif", "black.gif") 
	for (var i=1; i <= maxNumber ; i++) {
		graphicsList[graphicsList.length] = i + ".gif"
	}
	var alphabet = "abcdefghijklmnopqrstuvwxyz"
	for (i=0; i< alphabet.length; i++) {
		graphicsList[graphicsList.length] = i + ".gif"
		graphicsList[graphicsList.length] = i + "Wrong.gif"
	}
	for (i=0; i< graphicsList.length; i++) {
		this.images[i] = new Image()
		this.images[i].src = imagePath + graphicsList[i]
	}
}
		
function crosswordGenerateDisplay(){
	this.makeCorrectAnswers()
	var preloadedGraphics = new preloadGraphics(25, this.imagePath)
	var theHTML = ""
	theHTML += "<table width='80%' border='0' cellpadding='0' cellspacing='0'><tr><td>"
	if (this.intro.length > 0) {
		theHTML += "<p>" + this.intro + "</p>"
	}
	theHTML += "<p>" + this.makeBoardDisplay() + "</p>"
	
	theHTML += "<p><form name='Frm" + (this.ID + 1) + "' "
	theHTML += "method = 'post' action=''>"
	theHTML += this.makeClueList()
	theHTML += "</p><p><table width='100%' border='0' cellspacing='0' cellpadding='0'><TR><TD width='40%'>"
	theHTML += "<input type='text' size='25' name='Guess'></TD><TD align='left' valign='bottom'>"
	theHTML += "<a href='javascript:theTest.questions[" + this.ID + "].processGuess()'><IMG SRC='art/buttonPost1.gif' border='0'></a>"
	theHTML += "</TD></TR></TABLE></form></p><BR>"
	theHTML += "</td></tr></table>"
	if (this.parent.type == "Test") {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback())
	}
	return theHTML
}


function crosswordGenerateFeedback() {
	// alert(this.ID + ": crosswordGenerateFeedback()")
	var myFeedback = ""
	if (this.generateScore() < this.minimumScore) {
		myFeedback += this.messageWrong + "\r"
	} else {
		myFeedback += this.messageRight + "\r"
	}
	myFeedback += "Score: " + this.generateScore() + " of " + this.possibleScore + " points."
	return myFeedback
}

function crosswordShowAnswers(){
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function crosswordEraseCurrentAnswers() {
	for (var i=0; i < this.numRows * this.numCols; i++) {
		this.currentAnswers[i] = ""
		document.images["Xword" + this.ID + "Cell" + i].src = this.imagePath + "blank.gif"
	}
}

function crosswordMakeCorrectAnswers() {
	for (var i=0; i<this.rows*this.cols; i++) {
		this.correctAnswers[i]=""
	}
	for (var i=0; i<this.clues.length; i++) {
		this.postAnswer(i, this.clues[i].answer, "correct")
	}
}

function crosswordSetAnswers(typeAction) {
	var theAnswer
	if (typeAction == "Initial") {
		this.eraseCurrentAnswers()
		document.forms["Frm" + (this.ID + 1)].reset()
	} else if (typeAction == "Current") {
		for (var i=0; i < this.numRows * this.numCols; i++) {
			theCellValue = this.currentAnswers[i]
			if (theCellValue == "") {
				document.images["Xword" + this.ID + "Cell" + i].src = this.imagePath + "blank.gif"
			} else {
				document.images["Xword" + this.ID + "Cell" + i].src = this.imagePath + theCellValue + ".gif"
			}
		}
	} else if (typeAction == "Right") {
		this.eraseCurrentAnswers()
		for (var i=0; i < this.clues.length; i++) {
			this.postAnswer(i, this.clues[i].answer, "current")
		}
	} else {
		 alert("crosswordSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
}

function crosswordSetFlags(typeAction) {
	if (typeAction == "Clear") {
		for (var i=0; i< this.currentAnswers.length; i++) {
			if (this.currentAnswers[i] = "") {
				var myGraphic = this.imagePath + "blank.gif"
			} else {
				var myGraphic = this.imagePath + this.currentAnswers[i] + ".gif"
			}
			document.images["Xword" + this.ID + "Cell" + i].src = myGraphic
		}
	} else if (typeAction == "Score") {
		for (var i=0; i< this.board.length; i++) {
			if (this.board[i] != "b") {
				if (this.currentAnswers[i] != this.correctAnswers[i]) {
					if (this.currentAnswers[i] == "") {
						var myGraphic = this.imagePath + "blankWrong.gif"
					} else {
						var myGraphic = this.imagePath + this.currentAnswers[i] + "Wrong.gif"
					}
					document.images["Xword" + this.ID + "Cell" + i].src = myGraphic
				}
			}
		}
	} else {
		 alert("crosswordSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function crosswordReset(){
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function crosswordSaveAnswers() {	
	// Is anything needed here?
}
	
function crosswordGenerateScore() {
	var theScore = 0
	var numberSlots = 0
	var numberRight = 0
	for (var i=0; i<this.board.length; i++) {
		if (this.board[i] != "b") { // slot for a character
			numberSlots++
			if (this.currentAnswers[i] == this.correctAnswers[i]) {
				numberRight++
			}
		}
	}
	theScore = parseInt(this.possibleScore * (numberRight / numberSlots))

	return theScore
}
