// =============================================================
// File:     WHCclozeselect.js
// Contents: Basic scripts used for cloze-text activities
// Revised:  30-July-1999
// Copyright (c) 1997-1999 William Horton Consulting, Inc.
// =============================================================

function hClozeSelect() {
	this.ID = null          // Unique identifier for this question
	this.parent = null
	this.intro = ""               // Introductory text, usually the question itself
	this.possiblescore = 0        // Highest possible score
	this.messageRight = "You got all the items right."
	this.messageWrong = "You did NOT get all the items right."
	this.displayItemFeedback = false
	this.answers = new Array()     // Answer objects (zero-based)
	// Custom properties
	this.format = "paragraph"     //paragraph, table, table2, custom
	this.close = ""
	// Methods
	this.showAnswers = clozeSelectShowAnswers
	this.allowPartialCredit = false 
	//this.reset = clozeSelectReset
	this.generateDisplay = clozeSelectGenerateDisplay
	this.addAnswer = clozeSelectAddAnswer
	this.setAnswers = clozeSelectSetAnswers
	this.setFlags = clozeSelectSetFlags
	this.saveAnswers = clozeSelectSaveAnswers
	this.generateFeedback = clozeSelectGenerateFeedback
	this.generateScore = clozeSelectGenerateScore
	this.reset = clozeSelectReset
}

function hClozeSelectAnswer(listOfChoices, theAnswer, promptText, feedbackRight, feedbackWrong) {
	this.correctAnswer = theAnswer
	this.initialAnswer = 0
	this.currentAnswer = 0
	this.feedbackRight = feedbackRight
	this.feedbackWrong = feedbackWrong
	this.promptText = promptText
	this.listOfAnswers = listOfChoices
	this.isRight = clozeSelectAnswerIsRight
}

function clozeSelectGenerateDisplay(){
	var theHTML = ""
	if (this.format == "custom") {
		theHTML += this.intro
	} else {
		theHTML += "<p>" + this.intro + "</p>"
	}
	theHTML += "<form name='Frm" + this.ID + "'>\r"
	if (this.format == "paragraph") {
		theHTML += "<p>"
	} else if (this.format == "table") {
		theHTML += "<table width='95%' border='0'>"
	} else if (this.format == "table2") {
		theHTML += "<table width='95%' border='0'>"
	}
	for (var i=0; i< this.answers.length; i++) {
		theHTML += clozeSelectMakeRow(i, this.answers[i], this.ID, this.format)
	}
	if (this.format == "paragraph") {
		theHTML += "&nbsp;" + this.close + "</p>"
	} else if (this.format == "table") {
		theHTML += "</table>"
	} else if (this.format == "table2") {
		theHTML += "</table>"
	}
	theHTML += "</form>\r"
	if (this.format == "custom") {
		theHTML += this.close
	}
	if ((this.parent.type == "test") && (this.parent.showFeedback)) {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback())
	}
	theHTML = spaceOutLines(theHTML, 22)
	return theHTML
}

// Constructs the specific rows of the test initially.
function clozeSelectMakeRow(rowNum, theAnswer, theID, theFormat, theSize) {
	var theSize = theAnswer.size
	var theImg = "art/testscorenonenarrow.gif"
	var theSelectList = clozeSelectMakeList(theAnswer.listOfAnswers, ";", "Sel" + rowNum, "Pick one", 0, theID)
	if (theFormat == "paragraph") {
		theImg = "art/testscorenonenarrow.gif"
		theRow = theAnswer.promptText + "<img name='Img" + theID + rowNum + "' "
		theRow += "src='" + theImg + "'>" + theSelectList
	} else if (theFormat == "custom") {
		theRow = theAnswer.promptText + "<img name='Img" + theID + rowNum + "' "
		theRow += "src='" + theImg + "'>&nbsp;" + theSelectList
	} else if (theFormat == "table") {
		theRow = "<tr><td><img name='Img" + theID + rowNum + "' src='" + theImg + "'></td>"
		theRow += "<td>" + theSelectList
		theRow += "</td>"
		theRow += "<td>" + theAnswer.promptText + "</td>"
		theRow += "</tr>"
		theRow += "<tr><td colspan='2'>&nbsp;</td></tr>"
	} else if (theFormat == "table2") {
		theRow = "<tr><td valign='top'><p>" + theAnswer.promptText + "</p></td>"
		theRow += "<td valign='top'><img name='Img" + theID + rowNum + "' src='" + theImg + "'></td>"
		theRow += "<td valign='top'>" + theSelectList
		theRow += "</td>"
		theRow += "</tr>"
		theRow += "<tr><td colspan='2'>&nbsp;</td></tr>"
	} else {
		alert("clozeSelectMakeRow: format of " + theFormat + " is not recognized.")
	}
	return theRow
}

function clozeSelectMakeList(listOfChoices, itsDelimiter, itsName, zeroItem, itemSelected, itsQuestNum) {
	var arrayOfChoices = listOfChoices.split(itsDelimiter)
	var myHTML = "<select name='" + itsName + "' "
	myHTML += "onChange='theTest.questions[" + itsQuestNum + "].saveAnswers()'>"
	if (zeroItem.length > 0) {
		myHTML += "<option value='0'"
		if (itemSelected == 0) {myHTML += " SELECTED"}
		myHTML += ">" + zeroItem + "</option>"
	}
	for (var i=1; i<= arrayOfChoices.length; i++) {
		myHTML += "<option value='" + i + "'"
		if (itemSelected == i) {myHTML += " SELECTED"}
		myHTML += ">" + arrayOfChoices[i-1] + "</option>"
	}
	myHTML += "</select>"
	return myHTML
}

function clozeSelectGenerateFeedback() {
	var myFeedback = ""
	var myScore = parseInt(this.generateScore())
	if (myScore == this.possibleScore) {
		myFeedback += this.messageRight + "\r"
	} else {
		myFeedback += this.messageWrong + "\r"
	}
	myFeedback += "Score: " + myScore + " of " + this.possibleScore + " points.\r"
	if (this.displayItemFeedback) {
		for (i=0; i<this.answers.length; i++) {
			myFeedback += "Item " + (i + 1) + ": "
			if (this.answers[i].isRight(this.answers[i])) { 
				myFeedback += this.answers[i].feedbackRight + "\r"
			} else {
				myFeedback += this.answers[i].feedbackWrong + "\r"
			}
		}
	}
	return myFeedback
}

function clozeSelectAnswerIsRight(theSlot){
	if (theSlot.currentAnswer == theSlot.correctAnswer) {
		return true
	} else {
		return false
	}
}

function clozeSelectShowAnswers(){
	// alert(this.ID + ": clozeSelectShowAnswer()")
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function clozeSelectSetAnswers(typeAction) {
	if (typeAction == "Initial") {
	//alert("resetting?")
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].selectedIndex = this.answers[i].initialAnswer
			this.answers[i].currentAnswer = this.answers[i].initialAnswer
		}
	} else if (typeAction == "Current") {
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].selectedIndex = this.answers[i].currentAnswer
		}
	} else if (typeAction == "Right") {
			for (i=0; i<this.answers.length; i++) {
				document.forms["Frm" + this.ID].elements[i].selectedIndex = this.answers[i].correctAnswer
				this.answers[i].currentAnswer = this.answers[i].correctAnswer
			}
	} else {
		 alert("clozeSelectSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
}

function clozeSelectSetFlags(typeAction) {
	// alert ("In clozeSelectSetFlags with typeAction = " + typeAction)
	if (this.format == "paragraph") {
		var blankImage = "art/testscorenonenarrow.gif"
		var rightImage = "art/testscoreright.gif"
		var wrongImage = "art/testscorewrong.gif"
	} else {
		var blankImage = "art/testscorenonenarrow.gif"
		var rightImage = "art/testscoreright.gif"
		var wrongImage = "art/testscorewrong.gif"		
	}

	if (typeAction == "Clear") {
		if (this.format == "paragraph") { blankImage = "art/testscorenonenarrow.gif" }
		for (i=0; i<this.answers.length; i++) {
			document.images["Img" + this.ID + i].src= blankImage
		}
	} else if (typeAction == "Score") {
		for (i=0; i<this.answers.length; i++) {
			if (this.answers[i].isRight(this.answers[i])) { // right answer
					document.images["Img" + this.ID + i].src= rightImage
			} else {
				document.images["Img" + this.ID + i].src= wrongImage
			}
		}
	} else {
		 alert("clozeSelectSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function clozeSelectReset(){
	// alert("In clozeSelectReset() in Question " + this.ID)
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function clozeSelectAddAnswer(theAnswer) {
	// Replace with generic?
	if (theAnswer != null) {
		this.answers[this.answers.length] = theAnswer
	}
}

function clozeSelectSaveAnswers() {
	for (i = 0; i < this.answers.length; i++) {
		this.answers[i].currentAnswer = document.forms["Frm" + this.ID].elements[i].selectedIndex
	}
}

function clozeSelectGenerateScore() {
	var theScore = 0
	var theAnswer
	var rightAnswers = 0
	for (i=0; i < this.answers.length; i++) {
		theAnswer = this.answers[i]
		if (theAnswer.isRight(this.answers[i])) {
			rightAnswers += 1
		} else { 
			// rightAnswers -= 1   //this was subtracting double for each wrong answer
		}
	}
	if (rightAnswers > 0) {
		theScore = (rightAnswers / this.answers.length) * this.possibleScore
	}
	return theScore
}
