// =============================================================
// File:     WHCclozetext.js
// Contents: Basic scripts used for cloze-text activities
// Revised:  13 Jan 2000
// Copyright (c) 1997-2000 William Horton Consulting, Inc.
// =============================================================

function hClozeText() {
	this.ID = null          // Unique identifier for this question
	this.parent = null
	this.intro = ""               // Introductory text, usually the question itself
	this.possiblescore = 0        // Highest possible score
	this.messageRight = "All of the items are right."
	this.messageWrong = "Not all items are right."
	this.answers = new Array()     // Answer objects (zero-based)
	// Custom properties
	this.format = "paragraph"   //paragraph, table, table2, custom
	this.displayItemFeedback = false
	this.close = ""
	// Methods
	this.showAnswers = clozeTextShowAnswers
	this.reset = clozeTextReset
	this.generateDisplay = clozeTextGenerateDisplay
	this.addAnswer = clozeTextAddAnswer
	this.setAnswers = clozeTextSetAnswers
	this.setFlags = clozeTextSetFlags
	this.saveAnswers = clozeTextSaveAnswers
	this.generateFeedback = clozeTextGenerateFeedback
	this.generateScore = clozeTextGenerateScore
}

function hClozeTextAnswer(theAnswer, rightAnswerArray, promptText, theSize, feedbackRight, feedbackWrong) {
	this.correctAnswer = theAnswer
	this.rightAnswerArray = rightAnswerArray
	this.promptText = promptText
	this.size = 5
	this.initialAnswer = ""
	this.currentAnswer = ""
	this.feedbackRight = feedbackRight
	this.feedbackWrong = feedbackWrong
	this.isRight = clozeTextAnswerIsRight
}

function clozeTextGenerateDisplay(){
	var theHTML = ""
	if (this.format == "custom") {
		theHTML += this.intro
	} else {
		theHTML += "<p>" + this.intro + "</p>"
	}
	theHTML += "<form name='Frm" + this.ID + "'>\r"
	if (this.format == "paragraph") {
		theHTML += "<p>"
} else if (this.format == "table") {
		theHTML += "<table width='565' border='0'>"
	} else if (this.format == "table2") {
		theHTML += "<table width='100%' border='0'>"
	}
	for (var i=0; i< this.answers.length; i++) {
		theHTML += clozeTextMakeRow(i, this.answers[i], this.ID, this.format)
	}
	if (this.format == "paragraph") {
		theHTML += "&nbsp;" + this.close + "</p>"
	} else if (this.format == "table") {
		theHTML += "</table>"
	} else if (this.format == "table2") {
		theHTML += "</table>"
	}
	theHTML += "</form>"
	if (this.format == "custom") {
		theHTML += this.close
	}
	if ((this.parent.type == "test") && (this.parent.showFeedback)) {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback())
	}
	return theHTML
}

// Constructs the specific rows of the test initially.
function clozeTextMakeRow(rowNum, theAnswer, theID, theFormat, theSize) {
	var theSize = theAnswer.size
	var theImg = "art/testscorenone.gif"
	if (theFormat == "paragraph") {
		theImg = "art/testscorenonenarrow.gif"
		theRow = theAnswer.promptText + "<img name='Img" + theID + rowNum + "' "
		theRow += "src='" + theImg + "'><input type='text' name='Text" + theID + rowNum + "' "
		theRow += "size='" + theSize + "' onChange='theTest.questions[" + theID + "].saveAnswers()'> "
	} else if (theFormat == "custom") {
		theRow = theAnswer.promptText + "<img name='Img" + theID + rowNum + "' "
		theRow += "src='" + theImg + "'>&nbsp;<input type='text' name='Text" + theID + rowNum + "' "
		theRow += "size='" + theSize + "' onChange='theTest.questions[" + theID + "].saveAnswers()'> "
	} else if (theFormat == "table") {
		theRow = "<tr align='left'><td width='20'><img name='Img" + theID + rowNum + "' src='" + theImg + "'></td>"
		theRow += "<td><input type='text' name='Text" + theID + rowNum + "' "
		theRow += "size='" + theSize + "' onChange='theTest.questions[" + theID + "].saveAnswers()'>"
		theRow += "</td>"
		theRow += "<td width='380'><SPAN CLASS='formtext'>" + theAnswer.promptText + "</SPAN></td></tr>"
	} else if (theFormat == "table2") {
		theRow = "<tr><td valign='top'><SPAN CLASS='formtext'>" + theAnswer.promptText + "</SPAN></td>"
		theRow += "<td><img name='Img" + theID + rowNum + "' src='" + theImg + "'></td>"
		theRow += "<td width='100' valign='bottom'><input type='text' name='Text" + theID + rowNum + "' "
		theRow += "size='" + theSize + "' onChange='theTest.questions[" + theID + "].saveAnswers()'>"
		theRow += "</td></tr>"
		
	} else {
		alert("clozeTextMakeRow: format of " + theFormat + " is not recognized.")
	}
	return theRow
}

function clozeTextGenerateFeedback() {
	var myFeedback = ""
	var myScore = parseInt(this.generateScore())
	if (myScore == this.possibleScore) {
		myFeedback += this.messageRight + "\r"
	} else {
		myFeedback += this.messageWrong + "\r"
	}
	myFeedback += "Score: " + myScore + " of " + this.possibleScore + " points.\r"
	
	if (this.displayItemFeedback) {
		for (i=0; i<this.answers.length; i++) {
			myFeedback += "Item " + (i + 1) + ": "
			if (this.answers[i].isRight(this.answers[i])) { 
				myFeedback += this.answers[i].feedbackRight + "\r"
			} else {
				myFeedback += this.answers[i].feedbackWrong + "\r"
			}
		}
	}	
	return myFeedback
}

function clozeTextAnswerIsRight(theSlot){
	var numMatches = theTest.getNumTextMatches(this.currentAnswer, this.rightAnswerArray)
	if (numMatches > 0) {
		return true
	} else {
		return false
	}
}

function clozeTextShowAnswers(){
	// alert(this.ID + ": clozeTextShowAnswer()")
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function clozeTextSetAnswers(typeAction) {
	if (typeAction == "Initial") {
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].value = this.answers[i].initialAnswer
			this.answers[i].currentAnswer = this.answers[i].initialAnswer
		}
	} else if (typeAction == "Current") {
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].value = this.answers[i].currentAnswer
		}
	} else if (typeAction == "Right") {
			for (i=0; i<this.answers.length; i++) {
				document.forms["Frm" + this.ID].elements[i].value = this.answers[i].correctAnswer
				this.answers[i].currentAnswer = this.answers[i].correctAnswer
			}
	} else {
		 alert("clozeTextSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
}

function clozeTextSetFlags(typeAction) {
	// alert ("In clozeTextSetFlags with typeAction = " + typeAction)
	if (this.format == "paragraph") {
		var blankImage = "art/testscorenonenarrow.gif"
		var rightImage = "art/testscoreright.gif"
		var wrongImage = "art/testscorewrong.gif"
	} else {
		var blankImage = "art/testscorenone.gif"
		var rightImage = "art/testscoreright.gif"
		var wrongImage = "art/testscorewrong.gif"		
	}
	if (typeAction == "Clear") {
		for (i=0; i<this.answers.length; i++) {
			document.images["Img" + this.ID + i].src= blankImage
		}
	} else if (typeAction == "Score") {
		for (i=0; i<this.answers.length; i++) {
			if (this.answers[i].isRight(this.answers[i])) { // right answer
					document.images["Img" + this.ID + i].src= rightImage
			} else {
				document.images["Img" + this.ID + i].src = wrongImage	
			}
		}
	} else {
		 alert("clozeTextSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function clozeTextReset(){
	// alert("In clozeTextReset() in Question " + this.ID)
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function clozeTextAddAnswer(theAnswer) {
	// Replace with generic?
	if (theAnswer != null) {
		this.answers[this.answers.length] = theAnswer
	}
}

function clozeTextSaveAnswers() {
	for (i = 0; i < this.answers.length; i++) {
		this.answers[i].currentAnswer = document.forms["Frm" + this.ID].elements[i].value
	}
}

function clozeTextGenerateScore() {
	var theScore = 0
	var theAnswer
	var rightAnswers = 0
	for (i=0; i<this.answers.length; i++) {
		theAnswer = this.answers[i]
		if (theAnswer.isRight(this.answers[i])) {
			rightAnswers += 1
		} else { 
			// rightAnswers -= 1 //This counts wrong answers twice
		}
	}
	if (rightAnswers > 0) {
		theScore = (rightAnswers / this.answers.length) * this.possibleScore
	}
	return theScore
}

