// =============================================================
// File:     WHCjigsaw.js
// Contents: Basic scripts used for jigsaw puzzle activities
// Revised:  9-July-1999
// Copyright (c) 1997-1999 William Horton Consulting, Inc.
// =============================================================

function hJigSaw() {
	this.ID = null          // Unique identifier for this question
	this.parent = null
	this.intro = ""               // Introductory text, usually the question itself
	this.possibleScore = 0        // Highest possible score
	this.messageRight = ""
	this.messageWrong = ""
	// Specific properties
	this.imageWidth = 50
	this.imageHeight = 50
	this.numRows = 11
	this.numCols = 5
	this.imagePath = ""
	this.slotsImages = null
	this.slotsOrderInitial = null
	this.slotsOrderCurrent = new Array()
	this.movingSlot = false
	this.slotBeingMoved = 0
	this.bgGraphic = ""
	// Methods
	this.showAnswers = jigSawShowAnswers
	this.reset = jigSawReset
	this.generateDisplay = jigSawGenerateDisplay
	this.makeCell = jigSawMakeCell
	this.setAnswers = jigSawSetAnswers
	this.setFlags = jigSawSetFlags
	this.saveAnswers = jigSawSaveAnswers
	this.generateFeedback = jigSawGenerateFeedback
	this.generateScore = jigSawGenerateScore
	this.swapCells = jigSawSwapCells
	this.moveSlot = jigSawMoveSlot
	
}

function jigSawGenerateDisplay(){
	var theHTML = ""
	if (this.intro.length > 0) {
		theHTML += "<p>" + this.intro + "</p>"
	}
	// Find a better place for the score image
	theHTML += "<p><img name='Img" + this.ID + "' src='art/testscorenone.gif'></p>"
	
	theHTML += "<form name='Frm" + this.ID + "'>"
	
	theHTML += "<table border='0' cellpadding='0' cellspacing='0' width='" + (this.imageWidth * this.numCols+5) + "' background='" + this.imagePath + this.bgGraphic + "'>"
	
	for (var rowNum=1; rowNum<= this.numRows; rowNum++) {
		theHTML += "<tr>"
		for (var colNum=1; colNum <= this.numCols; colNum++) {
			var pieceNum = colNum + (rowNum - 1)* this.numCols
			theHTML += this.makeCell(pieceNum)	 
		}
		theHTML += "</tr><br>"
	}
	
	theHTML += "</table></form>"
	
	if ((this.parent.type == "test") && (this.parent.showFeedback)) {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback())
	}
	// alert(theHTML)
	return theHTML
}

function jigSawMakeCell(slotNum) {
	var myHTML = "<td width='" + this.imageWidth + "' height='" + this.imageHeight + "'>"
	myHTML = "<a href='javascript:eval(theTest.questions[" + this.ID + "].moveSlot(" + slotNum + "))'>"
	myHTML += "<img name='Img" + this.ID + slotNum + "' "
	myHTML += "src='" + this.imagePath + this.slotsImages[this.slotsOrderInitial[slotNum-1]-1] + "' "
	myHTML += " border='0'>"
	myHTML += "</a>"
	myHTML += "</td>"
	return myHTML
}

function jigSawGenerateFeedback() {
	// alert(this.ID + ": jigSawGenerateFeedback()")
	var myFeedback = ""
	var numberRight = 0
	for (var i=1; i<= this.slotsOrderCurrent.length; i++) {
		if (this.slotsOrderCurrent[i-1] == i) { numberRight++ }
	}
	if (numberRight == this.slotsOrderCurrent.length) {
		myFeedback += this.messageRight + "\r"
	} else {
		myFeedback += this.messageWrong + "\r"
	} 
	myFeedback += "Score: " + this.generateScore() + " of " + this.possibleScore + " points.\r"
	return myFeedback
}

function jigSawShowAnswers(){
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function jigSawSetAnswers(typeAction) {
	var theAnswer
	if (typeAction == "Initial") {
		for (var i=0; i< this.slotsOrderInitial.length; i++) {
			this.slotsOrderCurrent[i] = this.slotsOrderInitial[i]
			document.images["Img" + this.ID + (i+1)].src = this.imagePath + this.slotsImages[this.slotsOrderInitial[i]-1]
		}
	} else if (typeAction == "Current") {
		for (var i=0; i< this.slotsOrderCurrent.length; i++) {
			document.images["Img" + this.ID + (i+1)].src =  this.imagePath + this.slotsImages[this.slotsOrderCurrent[i]-1]
		}
	} else if (typeAction == "Right") {
		for (var i=1; i<= this.slotsImages.length; i++) {
			this.slotsOrderCurrent[i-1] = i
			document.images["Img" + this.ID + i].src =  this.imagePath + this.slotsImages[i-1]
		}
	} else {
		 alert("jigSawSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
}

function jigSawSetFlags(typeAction) {
	if (typeAction == "Clear") {
			document.images["Img" + this.ID].src="art/testscorenone.gif"
	} else if (typeAction == "Score") {
		var numRight = 0
		for (var i = 1; i < this.slotsImages.length; i++) {
			if (this.slotsOrderCurrent[i-1] == i) { numRight++ }
		}
		if (numRight == this.slotsImages.length - 1) {
			document.images["Img" + this.ID].src="art/testscoreright.gif"
		} else {
			document.images["Img" + this.ID].src="art/testscorewrong.gif"			
		}
	} else {
		 alert("jigSawSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function jigSawReset(){
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function jigSawSaveAnswers() {	
	// Is anything needed here?
}
	
function jigSawGenerateScore() {
	var theScore = 0
	var numberRight = 0
	for (i=0; i < this.slotsOrderCurrent.length; i++) {
		if (this.slotsOrderCurrent[i-1] == i) { numberRight++ }
	}
	theScore = parseInt((this.possibleScore/this.slotsOrderCurrent.length) * numberRight) + 1
	return theScore
}

function jigSawMoveSlot(slotNum) {
	// alert("jigSawMoveSlot(" + slotNum + ")")
	if (this.movingSlot) { // Have already picked up a piece
		this.swapCells(this.slotBeingMoved, slotNum)
		this.movingSlot = false
		this.slotBeingMoved = 0
	} else { // Starting movement
		this.movingSlot = true
		this.slotBeingMoved = slotNum
	}
}

function jigSawSwapCells(slotA, slotB) {
	// alert("In jigSawSwapCells(" + slotA + ", " + slotB + ")")
	
	var tempSlot = this.slotsOrderCurrent[slotA - 1]
	this.slotsOrderCurrent[slotA - 1] = this.slotsOrderCurrent[slotB - 1]
	this.slotsOrderCurrent[slotB - 1] = tempSlot
	// alert("this.slotsOrderCurrent[slotA -1] = "+  this.slotsOrderCurrent[slotA -1])
	document.images["Img" + this.ID + slotA].src = this.imagePath + this.slotsImages[this.slotsOrderCurrent[slotA -1]-1]
	document.images["Img" + this.ID + slotB].src = this.imagePath + this.slotsImages[this.slotsOrderCurrent[slotB -1]-1]
}

