// =============================================================
// File:     WHCmatch.js
// Contents: Basic scripts used for list-matching activities
// Revised:  23-July-1999
// Copyright (c) 1997-1999 William Horton Consulting, Inc.
// =============================================================

function hMatch() {
	this.ID = null          // Unique identifier for this question
	this.parent = null
	this.intro = ""               // Introductory text, usually the question itself
	this.possibleScore = 10        // Highest possible score
	this.messageRight = ""
	this.messageWrong = ""
	// Answer is built in
	this.left = new Array()
	this.right= new Array()
	this.matches = null
	this.matchesCurrent = new Array()
	// Methods
	this.showAnswers = matchShowAnswers
	this.reset = matchReset
	this.generateDisplay = matchGenerateDisplay
	this.makeChoiceList = matchMakeChoiceList
	this.showMatch = matchShowMatch
	this.doMatch = matchDoMatch
	this.setAnswers = matchSetAnswers
	this.setFlags = matchSetFlags
	this.saveAnswers = matchSaveAnswers
	this.generateFeedback = matchGenerateFeedback
	this.generateScore = matchGenerateScore
}

var alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

function matchGenerateDisplay(){
	var numOfChoices = this.matches.length
	var theHTML = ""
	theHTML += "<form name='Frm" + this.ID + "' action='nowhere.htm' method='get'>\r"
	theHTML += "<table border='0' width='90%' bgcolor='#ffffff'><tr valign='top'><td colspan='3'><P CLASS='formtextbold'>" + this.intro + "</P><BR></td></tr><tr valign='top'>"
	theHTML += "<td>" + this.makeChoiceList("left") + "</td>"
	theHTML += "<td>&nbsp;</td>"
	theHTML += "<td bgcolor='#eeeeee'>" + this.makeChoiceList("right") + "</td>"
	theHTML += "</tr></table>\r"
	theHTML += "<br>"
	theHTML += "</form>"
	return theHTML
}

function matchMakeChoiceList(leftOrRight){
	var numOptions = this.left.length - 1
	if (leftOrRight == "left") {
		choiceOptionList = makeChoiceOptions(numOptions, "alpha")
		tableBGColor = "#FFFFFF"
	} else {
		choiceOptionList = makeChoiceOptions(numOptions, "numeric")
		tableBGColor = "#eeeeee"
	}
	var theChoiceList = "<table width='100%' border=0 cellpadding='3' bgcolor='" + tableBGColor + "'>"
	for (i=1; i<= numOptions; i++) {
		theChoiceList += "<tr valign='top'>"
		if (leftOrRight == "left"){
			rowNum = i
			rowID = "l" + i
			rowText = this.left[i]
		} else {
			rowNum = alphabet.charAt(i-1)
			rowID =  "r" + i
			rowText = this.right[i]
		}
		theChoiceList += "<td><img name='Img" + this.ID + rowID + "' "
		theChoiceList += "src='art/testscorenone.gif'></td>"
		theChoiceList += "<td><select name='Sel" + rowID + "' "
		theChoiceList += "onChange='theTest.questions[" + this.ID + "].showMatch(this)'>"
		theChoiceList += choiceOptionList + "</select></td>"
		theChoiceList += "<td CLASS='tablehead'>" + rowNum + "</td>"
		theChoiceList += "<td CLASS='tabledata'>" + rowText + "</td>"
		theChoiceList += "</tr>"
	}
	theChoiceList += "</table>"
	return theChoiceList
}

function makeChoiceOptions(numOptions, alphaOrNumeric) {
	var theList = "<option value='0' CHECKED> "
	for (i=1; i<= numOptions; i++) {
		theList += "<option value='" + i + "'>";
		if (alphaOrNumeric == "alpha") {
			theList += alphabet.charAt(i-1);
		} else {
			theList += i
		}
	}
	return theList
}

function matchShowMatch(theChoice) {
	if (theChoice.selectedIndex > 0) {
		lrPosition = 3 
		theLR = theChoice.name.charAt(lrPosition)
		myIndex = theChoice.name.substring(lrPosition + 1, theChoice.name.length)
	
		if (theLR == "l") {
			leftIndex = myIndex
			rightIndex = theChoice.selectedIndex
		} else {
			leftIndex = theChoice.selectedIndex
			rightIndex = myIndex
		}
	
		this.doMatch(leftIndex, rightIndex)
		// giveFeedback(theChoice.name, "hint")	
	}
}

function matchDoMatch(leftIndex, rightIndex) {
	// First turn off any current matches to the chosen items
	var targetPrefix = "document.Frm" + this.ID + "." + "Sel"
	for (i=1; i<= this.matches.length; i++) {
		var theTarget = targetPrefix + "l" + i + ".selectedIndex == " + rightIndex
		// alert("theTarget = '" + theTarget)
		if (eval(theTarget)) eval(targetPrefix + "l" + i + "[0].selected=true")	
		theTarget = targetPrefix + "r" + i + ".selectedIndex == " + leftIndex
		if (eval(theTarget)) eval(targetPrefix + "r" + i + "[0].selected=true")	
	}
	theTarget = targetPrefix + "l" + leftIndex + "[" + rightIndex + "].selected = true"
	eval(theTarget)
	theTarget = targetPrefix + "r" + rightIndex + "[" + leftIndex + "].selected = true"
	eval(theTarget)
	// Update the current matches
	this.matchesCurrent[leftIndex-1] = rightIndex	
}

function matchGenerateFeedback() {
	// alert(this.ID + ": matchGenerateFeedback()")
	var myFeedback = ""
	var numberRight = 0
	var selPre = "document.Frm" + this.ID + ".Sel"
	var imgPre = "document.Img" + this.ID
	for (var j=1; j<=this.matches.length; j++) {
		var evalTarget = selPre + "l" + j + ".selectedIndex==" + this.matches[j-1]
		// alert("evalTarget = " + evalTarget)
		if (eval(evalTarget)) {numberRight++}
	}
	myFeedback += "You got " + numberRight + " of " + this.matches.length + " right. \r"
	if (numberRight == this.matches.length) {
		myFeedback += this.messageRight + "\r"
	} else { 
		myFeedback += this.messageWrong + "\r"
	}
	myFeedback += "Score: " + this.generateScore() + " of " + this.possibleScore + " points.\r"
	return myFeedback
}

function matchShowAnswers(){
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function matchSetAnswers(typeAction) {
	// alert("In matchSetAnswers('" + typeAction + "')")
	var theAnswer
	if (typeAction == "Initial") {
		document.forms["Frm" + this.ID].reset()
		for (var i=0; i< this.matches.length; i++) {
			this.matchesCurrent[i] = 0
		}
	} else if (typeAction == "Current") {
		for (var i=0; i< this.matchesCurrent.length; i++) {
			document.forms["Frm" + this.ID].elements[i].selectedIndex = this.matchesCurrent[i] 
		}
	} else if (typeAction == "Right") {
		for (i=0; i< this.matches.length; i++) {
			this.matchesCurrent[i] = this.matches[i]
			// document.forms["Frm" + this.ID].elements[i].selectedIndex = this.matches[i]
			this.doMatch(i+1, this.matches[i])
		}
	} else {
		 alert("matchSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
}

function matchSetFlags(typeAction) {
	// alert("In matchSetFlags('" + typeAction + "')")
	if (typeAction == "Clear") {
		for (var i = 1; i < this.left.length; i++) {
			// alert("Image name is " + "Img" + this.ID + "l" + i)
			document.images["Img" + this.ID + "l" + i].src="art/testscorenone.gif"
			document.images["Img" + this.ID + "r" + i].src="art/testscorenone.gif"
		}
	} else if (typeAction == "Score") {
		for (var i = 0; i < this.matches.length; i++) {
			if (this.matchesCurrent[i] == this.matches[i]) { // right
				document.images["Img" + this.ID + "l" + (i+1)].src="art/testscoreright.gif"
				document.images["Img" + this.ID + "r" + this.matches[i]].src="art/testscoreright.gif"
			} else {
				document.images["Img" + this.ID + "l" + (i+1)].src="art/testscorewrong.gif"
				document.images["Img" + this.ID + "r" + this.matches[i]].src="art/testscorewrong.gif"

			}
		}
	} else {
		 alert("matchSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function matchReset(){
	// alert("in matchReset")
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function matchSaveAnswers() {	
	// Nothing needed as score is updated with each change
}
	
function matchGenerateScore() {
	var theScore = 0
	var numberRight = 0
	for (i=0; i < this.matches.length; i++) {
		if (this.matches[i] == this.matchesCurrent[i]) { numberRight++ }
	}
	theScore = (this.possibleScore/this.matches.length) * numberRight
	return theScore
}
		

